/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.TimecodeSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimecodeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimecodeConfig> {
    private static final SdkField<String> ANCHOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Anchor").getter(TimecodeConfig.getter(TimecodeConfig::anchor)).setter(TimecodeConfig.setter(Builder::anchor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anchor").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(TimecodeConfig.getter(TimecodeConfig::sourceAsString)).setter(TimecodeConfig.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Start").getter(TimecodeConfig.getter(TimecodeConfig::start)).setter(TimecodeConfig.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()}).build();
    private static final SdkField<String> TIMESTAMP_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimestampOffset").getter(TimecodeConfig.getter(TimecodeConfig::timestampOffset)).setter(TimecodeConfig.setter(Builder::timestampOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampOffset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANCHOR_FIELD, SOURCE_FIELD, START_FIELD, TIMESTAMP_OFFSET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("anchor", ANCHOR_FIELD);
            this.put("source", SOURCE_FIELD);
            this.put("start", START_FIELD);
            this.put("timestampOffset", TIMESTAMP_OFFSET_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String anchor;
    private final String source;
    private final String start;
    private final String timestampOffset;

    private TimecodeConfig(BuilderImpl builder) {
        this.anchor = builder.anchor;
        this.source = builder.source;
        this.start = builder.start;
        this.timestampOffset = builder.timestampOffset;
    }

    public final String anchor() {
        return this.anchor;
    }

    public final TimecodeSource source() {
        return TimecodeSource.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public final String start() {
        return this.start;
    }

    public final String timestampOffset() {
        return this.timestampOffset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.anchor());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampOffset());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimecodeConfig)) {
            return false;
        }
        TimecodeConfig other = (TimecodeConfig)obj;
        return Objects.equals(this.anchor(), other.anchor()) && Objects.equals(this.sourceAsString(), other.sourceAsString()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.timestampOffset(), other.timestampOffset());
    }

    public final String toString() {
        return ToString.builder((String)"TimecodeConfig").add("Anchor", (Object)this.anchor()).add("Source", (Object)this.sourceAsString()).add("Start", (Object)this.start()).add("TimestampOffset", (Object)this.timestampOffset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Anchor": {
                return Optional.ofNullable(clazz.cast(this.anchor()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
            case "Start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "TimestampOffset": {
                return Optional.ofNullable(clazz.cast(this.timestampOffset()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TimecodeConfig, T> g) {
        return obj -> g.apply((TimecodeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String anchor;
        private String source;
        private String start;
        private String timestampOffset;

        private BuilderImpl() {
        }

        private BuilderImpl(TimecodeConfig model) {
            this.anchor(model.anchor);
            this.source(model.source);
            this.start(model.start);
            this.timestampOffset(model.timestampOffset);
        }

        public final String getAnchor() {
            return this.anchor;
        }

        public final void setAnchor(String anchor) {
            this.anchor = anchor;
        }

        @Override
        public final Builder anchor(String anchor) {
            this.anchor = anchor;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(TimecodeSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final String getStart() {
            return this.start;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final String getTimestampOffset() {
            return this.timestampOffset;
        }

        public final void setTimestampOffset(String timestampOffset) {
            this.timestampOffset = timestampOffset;
        }

        @Override
        public final Builder timestampOffset(String timestampOffset) {
            this.timestampOffset = timestampOffset;
            return this;
        }

        public TimecodeConfig build() {
            return new TimecodeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimecodeConfig> {
        public Builder anchor(String var1);

        public Builder source(String var1);

        public Builder source(TimecodeSource var1);

        public Builder start(String var1);

        public Builder timestampOffset(String var1);
    }
}

