/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.EncryptionContractConfiguration;
import software.amazon.awssdk.services.mediaconvert.model.___listOf__stringPattern09aFAF809aFAF409aFAF409aFAF409aFAF12Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpekeKeyProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpekeKeyProvider> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateArn").getter(SpekeKeyProvider.getter(SpekeKeyProvider::certificateArn)).setter(SpekeKeyProvider.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<EncryptionContractConfiguration> ENCRYPTION_CONTRACT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionContractConfiguration").getter(SpekeKeyProvider.getter(SpekeKeyProvider::encryptionContractConfiguration)).setter(SpekeKeyProvider.setter(Builder::encryptionContractConfiguration)).constructor(EncryptionContractConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionContractConfiguration").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(SpekeKeyProvider.getter(SpekeKeyProvider::resourceId)).setter(SpekeKeyProvider.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<List<String>> SYSTEM_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SystemIds").getter(SpekeKeyProvider.getter(SpekeKeyProvider::systemIds)).setter(SpekeKeyProvider.setter(Builder::systemIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(SpekeKeyProvider.getter(SpekeKeyProvider::url)).setter(SpekeKeyProvider.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD, ENCRYPTION_CONTRACT_CONFIGURATION_FIELD, RESOURCE_ID_FIELD, SYSTEM_IDS_FIELD, URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("certificateArn", CERTIFICATE_ARN_FIELD);
            this.put("encryptionContractConfiguration", ENCRYPTION_CONTRACT_CONFIGURATION_FIELD);
            this.put("resourceId", RESOURCE_ID_FIELD);
            this.put("systemIds", SYSTEM_IDS_FIELD);
            this.put("url", URL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String certificateArn;
    private final EncryptionContractConfiguration encryptionContractConfiguration;
    private final String resourceId;
    private final List<String> systemIds;
    private final String url;

    private SpekeKeyProvider(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.encryptionContractConfiguration = builder.encryptionContractConfiguration;
        this.resourceId = builder.resourceId;
        this.systemIds = builder.systemIds;
        this.url = builder.url;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final EncryptionContractConfiguration encryptionContractConfiguration() {
        return this.encryptionContractConfiguration;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final boolean hasSystemIds() {
        return this.systemIds != null && !(this.systemIds instanceof SdkAutoConstructList);
    }

    public final List<String> systemIds() {
        return this.systemIds;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionContractConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSystemIds() ? this.systemIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpekeKeyProvider)) {
            return false;
        }
        SpekeKeyProvider other = (SpekeKeyProvider)obj;
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.encryptionContractConfiguration(), other.encryptionContractConfiguration()) && Objects.equals(this.resourceId(), other.resourceId()) && this.hasSystemIds() == other.hasSystemIds() && Objects.equals(this.systemIds(), other.systemIds()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"SpekeKeyProvider").add("CertificateArn", (Object)this.certificateArn()).add("EncryptionContractConfiguration", (Object)this.encryptionContractConfiguration()).add("ResourceId", (Object)this.resourceId()).add("SystemIds", this.hasSystemIds() ? this.systemIds() : null).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "EncryptionContractConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionContractConfiguration()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "SystemIds": {
                return Optional.ofNullable(clazz.cast(this.systemIds()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SpekeKeyProvider, T> g) {
        return obj -> g.apply((SpekeKeyProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private EncryptionContractConfiguration encryptionContractConfiguration;
        private String resourceId;
        private List<String> systemIds = DefaultSdkAutoConstructList.getInstance();
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(SpekeKeyProvider model) {
            this.certificateArn(model.certificateArn);
            this.encryptionContractConfiguration(model.encryptionContractConfiguration);
            this.resourceId(model.resourceId);
            this.systemIds(model.systemIds);
            this.url(model.url);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final EncryptionContractConfiguration.Builder getEncryptionContractConfiguration() {
            return this.encryptionContractConfiguration != null ? this.encryptionContractConfiguration.toBuilder() : null;
        }

        public final void setEncryptionContractConfiguration(EncryptionContractConfiguration.BuilderImpl encryptionContractConfiguration) {
            this.encryptionContractConfiguration = encryptionContractConfiguration != null ? encryptionContractConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionContractConfiguration(EncryptionContractConfiguration encryptionContractConfiguration) {
            this.encryptionContractConfiguration = encryptionContractConfiguration;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Collection<String> getSystemIds() {
            if (this.systemIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.systemIds;
        }

        public final void setSystemIds(Collection<String> systemIds) {
            this.systemIds = ___listOf__stringPattern09aFAF809aFAF409aFAF409aFAF409aFAF12Copier.copy(systemIds);
        }

        @Override
        public final Builder systemIds(Collection<String> systemIds) {
            this.systemIds = ___listOf__stringPattern09aFAF809aFAF409aFAF409aFAF409aFAF12Copier.copy(systemIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemIds(String ... systemIds) {
            this.systemIds(Arrays.asList(systemIds));
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public SpekeKeyProvider build() {
            return new SpekeKeyProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpekeKeyProvider> {
        public Builder certificateArn(String var1);

        public Builder encryptionContractConfiguration(EncryptionContractConfiguration var1);

        default public Builder encryptionContractConfiguration(Consumer<EncryptionContractConfiguration.Builder> encryptionContractConfiguration) {
            return this.encryptionContractConfiguration((EncryptionContractConfiguration)((EncryptionContractConfiguration.Builder)EncryptionContractConfiguration.builder().applyMutation(encryptionContractConfiguration)).build());
        }

        public Builder resourceId(String var1);

        public Builder systemIds(Collection<String> var1);

        public Builder systemIds(String ... var1);

        public Builder url(String var1);
    }
}

