/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.InputPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Policy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Policy> {
    private static final SdkField<String> HTTP_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpInputs").getter(Policy.getter(Policy::httpInputsAsString)).setter(Policy.setter(Builder::httpInputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpInputs").build()}).build();
    private static final SdkField<String> HTTPS_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpsInputs").getter(Policy.getter(Policy::httpsInputsAsString)).setter(Policy.setter(Builder::httpsInputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpsInputs").build()}).build();
    private static final SdkField<String> S3_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Inputs").getter(Policy.getter(Policy::s3InputsAsString)).setter(Policy.setter(Builder::s3Inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Inputs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_INPUTS_FIELD, HTTPS_INPUTS_FIELD, S3_INPUTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("httpInputs", HTTP_INPUTS_FIELD);
            this.put("httpsInputs", HTTPS_INPUTS_FIELD);
            this.put("s3Inputs", S3_INPUTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String httpInputs;
    private final String httpsInputs;
    private final String s3Inputs;

    private Policy(BuilderImpl builder) {
        this.httpInputs = builder.httpInputs;
        this.httpsInputs = builder.httpsInputs;
        this.s3Inputs = builder.s3Inputs;
    }

    public final InputPolicy httpInputs() {
        return InputPolicy.fromValue(this.httpInputs);
    }

    public final String httpInputsAsString() {
        return this.httpInputs;
    }

    public final InputPolicy httpsInputs() {
        return InputPolicy.fromValue(this.httpsInputs);
    }

    public final String httpsInputsAsString() {
        return this.httpsInputs;
    }

    public final InputPolicy s3Inputs() {
        return InputPolicy.fromValue(this.s3Inputs);
    }

    public final String s3InputsAsString() {
        return this.s3Inputs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpInputsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpsInputsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3InputsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policy)) {
            return false;
        }
        Policy other = (Policy)obj;
        return Objects.equals(this.httpInputsAsString(), other.httpInputsAsString()) && Objects.equals(this.httpsInputsAsString(), other.httpsInputsAsString()) && Objects.equals(this.s3InputsAsString(), other.s3InputsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Policy").add("HttpInputs", (Object)this.httpInputsAsString()).add("HttpsInputs", (Object)this.httpsInputsAsString()).add("S3Inputs", (Object)this.s3InputsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HttpInputs": {
                return Optional.ofNullable(clazz.cast(this.httpInputsAsString()));
            }
            case "HttpsInputs": {
                return Optional.ofNullable(clazz.cast(this.httpsInputsAsString()));
            }
            case "S3Inputs": {
                return Optional.ofNullable(clazz.cast(this.s3InputsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Policy, T> g) {
        return obj -> g.apply((Policy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String httpInputs;
        private String httpsInputs;
        private String s3Inputs;

        private BuilderImpl() {
        }

        private BuilderImpl(Policy model) {
            this.httpInputs(model.httpInputs);
            this.httpsInputs(model.httpsInputs);
            this.s3Inputs(model.s3Inputs);
        }

        public final String getHttpInputs() {
            return this.httpInputs;
        }

        public final void setHttpInputs(String httpInputs) {
            this.httpInputs = httpInputs;
        }

        @Override
        public final Builder httpInputs(String httpInputs) {
            this.httpInputs = httpInputs;
            return this;
        }

        @Override
        public final Builder httpInputs(InputPolicy httpInputs) {
            this.httpInputs(httpInputs == null ? null : httpInputs.toString());
            return this;
        }

        public final String getHttpsInputs() {
            return this.httpsInputs;
        }

        public final void setHttpsInputs(String httpsInputs) {
            this.httpsInputs = httpsInputs;
        }

        @Override
        public final Builder httpsInputs(String httpsInputs) {
            this.httpsInputs = httpsInputs;
            return this;
        }

        @Override
        public final Builder httpsInputs(InputPolicy httpsInputs) {
            this.httpsInputs(httpsInputs == null ? null : httpsInputs.toString());
            return this;
        }

        public final String getS3Inputs() {
            return this.s3Inputs;
        }

        public final void setS3Inputs(String s3Inputs) {
            this.s3Inputs = s3Inputs;
        }

        @Override
        public final Builder s3Inputs(String s3Inputs) {
            this.s3Inputs = s3Inputs;
            return this;
        }

        @Override
        public final Builder s3Inputs(InputPolicy s3Inputs) {
            this.s3Inputs(s3Inputs == null ? null : s3Inputs.toString());
            return this;
        }

        public Policy build() {
            return new Policy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Policy> {
        public Builder httpInputs(String var1);

        public Builder httpInputs(InputPolicy var1);

        public Builder httpsInputs(String var1);

        public Builder httpsInputs(InputPolicy var1);

        public Builder s3Inputs(String var1);

        public Builder s3Inputs(InputPolicy var1);
    }
}

