/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceentitlement.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.marketplaceentitlement.MarketplaceEntitlementAsyncClient;
import software.amazon.awssdk.services.marketplaceentitlement.internal.UserAgentUtils;
import software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsRequest;
import software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsResponse;

public class GetEntitlementsPublisher
implements SdkPublisher<GetEntitlementsResponse> {
    private final MarketplaceEntitlementAsyncClient client;
    private final GetEntitlementsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetEntitlementsPublisher(MarketplaceEntitlementAsyncClient client, GetEntitlementsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetEntitlementsPublisher(MarketplaceEntitlementAsyncClient client, GetEntitlementsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetEntitlementsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetEntitlementsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetEntitlementsResponseFetcher
    implements AsyncPageFetcher<GetEntitlementsResponse> {
        private GetEntitlementsResponseFetcher() {
        }

        public boolean hasNextPage(GetEntitlementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetEntitlementsResponse> nextPage(GetEntitlementsResponse previousPage) {
            if (previousPage == null) {
                return GetEntitlementsPublisher.this.client.getEntitlements(GetEntitlementsPublisher.this.firstRequest);
            }
            return GetEntitlementsPublisher.this.client.getEntitlements((GetEntitlementsRequest)((Object)GetEntitlementsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

