/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplacecatalog.model.SaaSProductEntityIdFilter;
import software.amazon.awssdk.services.marketplacecatalog.model.SaaSProductLastModifiedDateFilter;
import software.amazon.awssdk.services.marketplacecatalog.model.SaaSProductTitleFilter;
import software.amazon.awssdk.services.marketplacecatalog.model.SaaSProductVisibilityFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SaaSProductFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SaaSProductFilters> {
    private static final SdkField<SaaSProductEntityIdFilter> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntityId").getter(SaaSProductFilters.getter(SaaSProductFilters::entityId)).setter(SaaSProductFilters.setter(Builder::entityId)).constructor(SaaSProductEntityIdFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()}).build();
    private static final SdkField<SaaSProductTitleFilter> PRODUCT_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProductTitle").getter(SaaSProductFilters.getter(SaaSProductFilters::productTitle)).setter(SaaSProductFilters.setter(Builder::productTitle)).constructor(SaaSProductTitleFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductTitle").build()}).build();
    private static final SdkField<SaaSProductVisibilityFilter> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Visibility").getter(SaaSProductFilters.getter(SaaSProductFilters::visibility)).setter(SaaSProductFilters.setter(Builder::visibility)).constructor(SaaSProductVisibilityFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<SaaSProductLastModifiedDateFilter> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedDate").getter(SaaSProductFilters.getter(SaaSProductFilters::lastModifiedDate)).setter(SaaSProductFilters.setter(Builder::lastModifiedDate)).constructor(SaaSProductLastModifiedDateFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD, PRODUCT_TITLE_FIELD, VISIBILITY_FIELD, LAST_MODIFIED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EntityId", ENTITY_ID_FIELD);
            this.put("ProductTitle", PRODUCT_TITLE_FIELD);
            this.put("Visibility", VISIBILITY_FIELD);
            this.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SaaSProductEntityIdFilter entityId;
    private final SaaSProductTitleFilter productTitle;
    private final SaaSProductVisibilityFilter visibility;
    private final SaaSProductLastModifiedDateFilter lastModifiedDate;

    private SaaSProductFilters(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.productTitle = builder.productTitle;
        this.visibility = builder.visibility;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final SaaSProductEntityIdFilter entityId() {
        return this.entityId;
    }

    public final SaaSProductTitleFilter productTitle() {
        return this.productTitle;
    }

    public final SaaSProductVisibilityFilter visibility() {
        return this.visibility;
    }

    public final SaaSProductLastModifiedDateFilter lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibility());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SaaSProductFilters)) {
            return false;
        }
        SaaSProductFilters other = (SaaSProductFilters)obj;
        return Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.productTitle(), other.productTitle()) && Objects.equals(this.visibility(), other.visibility()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"SaaSProductFilters").add("EntityId", (Object)this.entityId()).add("ProductTitle", (Object)this.productTitle()).add("Visibility", (Object)this.visibility()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "ProductTitle": {
                return Optional.ofNullable(clazz.cast(this.productTitle()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibility()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SaaSProductFilters, T> g) {
        return obj -> g.apply((SaaSProductFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SaaSProductEntityIdFilter entityId;
        private SaaSProductTitleFilter productTitle;
        private SaaSProductVisibilityFilter visibility;
        private SaaSProductLastModifiedDateFilter lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SaaSProductFilters model) {
            this.entityId(model.entityId);
            this.productTitle(model.productTitle);
            this.visibility(model.visibility);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final SaaSProductEntityIdFilter.Builder getEntityId() {
            return this.entityId != null ? this.entityId.toBuilder() : null;
        }

        public final void setEntityId(SaaSProductEntityIdFilter.BuilderImpl entityId) {
            this.entityId = entityId != null ? entityId.build() : null;
        }

        @Override
        public final Builder entityId(SaaSProductEntityIdFilter entityId) {
            this.entityId = entityId;
            return this;
        }

        public final SaaSProductTitleFilter.Builder getProductTitle() {
            return this.productTitle != null ? this.productTitle.toBuilder() : null;
        }

        public final void setProductTitle(SaaSProductTitleFilter.BuilderImpl productTitle) {
            this.productTitle = productTitle != null ? productTitle.build() : null;
        }

        @Override
        public final Builder productTitle(SaaSProductTitleFilter productTitle) {
            this.productTitle = productTitle;
            return this;
        }

        public final SaaSProductVisibilityFilter.Builder getVisibility() {
            return this.visibility != null ? this.visibility.toBuilder() : null;
        }

        public final void setVisibility(SaaSProductVisibilityFilter.BuilderImpl visibility) {
            this.visibility = visibility != null ? visibility.build() : null;
        }

        @Override
        public final Builder visibility(SaaSProductVisibilityFilter visibility) {
            this.visibility = visibility;
            return this;
        }

        public final SaaSProductLastModifiedDateFilter.Builder getLastModifiedDate() {
            return this.lastModifiedDate != null ? this.lastModifiedDate.toBuilder() : null;
        }

        public final void setLastModifiedDate(SaaSProductLastModifiedDateFilter.BuilderImpl lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate != null ? lastModifiedDate.build() : null;
        }

        @Override
        public final Builder lastModifiedDate(SaaSProductLastModifiedDateFilter lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public SaaSProductFilters build() {
            return new SaaSProductFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SaaSProductFilters> {
        public Builder entityId(SaaSProductEntityIdFilter var1);

        default public Builder entityId(Consumer<SaaSProductEntityIdFilter.Builder> entityId) {
            return this.entityId((SaaSProductEntityIdFilter)((SaaSProductEntityIdFilter.Builder)SaaSProductEntityIdFilter.builder().applyMutation(entityId)).build());
        }

        public Builder productTitle(SaaSProductTitleFilter var1);

        default public Builder productTitle(Consumer<SaaSProductTitleFilter.Builder> productTitle) {
            return this.productTitle((SaaSProductTitleFilter)((SaaSProductTitleFilter.Builder)SaaSProductTitleFilter.builder().applyMutation(productTitle)).build());
        }

        public Builder visibility(SaaSProductVisibilityFilter var1);

        default public Builder visibility(Consumer<SaaSProductVisibilityFilter.Builder> visibility) {
            return this.visibility((SaaSProductVisibilityFilter)((SaaSProductVisibilityFilter.Builder)SaaSProductVisibilityFilter.builder().applyMutation(visibility)).build());
        }

        public Builder lastModifiedDate(SaaSProductLastModifiedDateFilter var1);

        default public Builder lastModifiedDate(Consumer<SaaSProductLastModifiedDateFilter.Builder> lastModifiedDate) {
            return this.lastModifiedDate((SaaSProductLastModifiedDateFilter)((SaaSProductLastModifiedDateFilter.Builder)SaaSProductLastModifiedDateFilter.builder().applyMutation(lastModifiedDate)).build());
        }
    }
}

