/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.marketplacecatalog.model.AmiProductFilters;
import software.amazon.awssdk.services.marketplacecatalog.model.ContainerProductFilters;
import software.amazon.awssdk.services.marketplacecatalog.model.DataProductFilters;
import software.amazon.awssdk.services.marketplacecatalog.model.OfferFilters;
import software.amazon.awssdk.services.marketplacecatalog.model.ResaleAuthorizationFilters;
import software.amazon.awssdk.services.marketplacecatalog.model.SaaSProductFilters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityTypeFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityTypeFilters> {
    private static final SdkField<DataProductFilters> DATA_PRODUCT_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataProductFilters").getter(EntityTypeFilters.getter(EntityTypeFilters::dataProductFilters)).setter(EntityTypeFilters.setter(Builder::dataProductFilters)).constructor(DataProductFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProductFilters").build()}).build();
    private static final SdkField<SaaSProductFilters> SAA_S_PRODUCT_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SaaSProductFilters").getter(EntityTypeFilters.getter(EntityTypeFilters::saaSProductFilters)).setter(EntityTypeFilters.setter(Builder::saaSProductFilters)).constructor(SaaSProductFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaaSProductFilters").build()}).build();
    private static final SdkField<AmiProductFilters> AMI_PRODUCT_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmiProductFilters").getter(EntityTypeFilters.getter(EntityTypeFilters::amiProductFilters)).setter(EntityTypeFilters.setter(Builder::amiProductFilters)).constructor(AmiProductFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiProductFilters").build()}).build();
    private static final SdkField<OfferFilters> OFFER_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OfferFilters").getter(EntityTypeFilters.getter(EntityTypeFilters::offerFilters)).setter(EntityTypeFilters.setter(Builder::offerFilters)).constructor(OfferFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferFilters").build()}).build();
    private static final SdkField<ContainerProductFilters> CONTAINER_PRODUCT_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContainerProductFilters").getter(EntityTypeFilters.getter(EntityTypeFilters::containerProductFilters)).setter(EntityTypeFilters.setter(Builder::containerProductFilters)).constructor(ContainerProductFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerProductFilters").build()}).build();
    private static final SdkField<ResaleAuthorizationFilters> RESALE_AUTHORIZATION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResaleAuthorizationFilters").getter(EntityTypeFilters.getter(EntityTypeFilters::resaleAuthorizationFilters)).setter(EntityTypeFilters.setter(Builder::resaleAuthorizationFilters)).constructor(ResaleAuthorizationFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResaleAuthorizationFilters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PRODUCT_FILTERS_FIELD, SAA_S_PRODUCT_FILTERS_FIELD, AMI_PRODUCT_FILTERS_FIELD, OFFER_FILTERS_FIELD, CONTAINER_PRODUCT_FILTERS_FIELD, RESALE_AUTHORIZATION_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataProductFilters", DATA_PRODUCT_FILTERS_FIELD);
            this.put("SaaSProductFilters", SAA_S_PRODUCT_FILTERS_FIELD);
            this.put("AmiProductFilters", AMI_PRODUCT_FILTERS_FIELD);
            this.put("OfferFilters", OFFER_FILTERS_FIELD);
            this.put("ContainerProductFilters", CONTAINER_PRODUCT_FILTERS_FIELD);
            this.put("ResaleAuthorizationFilters", RESALE_AUTHORIZATION_FILTERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final DataProductFilters dataProductFilters;
    private final SaaSProductFilters saaSProductFilters;
    private final AmiProductFilters amiProductFilters;
    private final OfferFilters offerFilters;
    private final ContainerProductFilters containerProductFilters;
    private final ResaleAuthorizationFilters resaleAuthorizationFilters;
    private final Type type;

    private EntityTypeFilters(BuilderImpl builder) {
        this.dataProductFilters = builder.dataProductFilters;
        this.saaSProductFilters = builder.saaSProductFilters;
        this.amiProductFilters = builder.amiProductFilters;
        this.offerFilters = builder.offerFilters;
        this.containerProductFilters = builder.containerProductFilters;
        this.resaleAuthorizationFilters = builder.resaleAuthorizationFilters;
        this.type = builder.type;
    }

    public final DataProductFilters dataProductFilters() {
        return this.dataProductFilters;
    }

    public final SaaSProductFilters saaSProductFilters() {
        return this.saaSProductFilters;
    }

    public final AmiProductFilters amiProductFilters() {
        return this.amiProductFilters;
    }

    public final OfferFilters offerFilters() {
        return this.offerFilters;
    }

    public final ContainerProductFilters containerProductFilters() {
        return this.containerProductFilters;
    }

    public final ResaleAuthorizationFilters resaleAuthorizationFilters() {
        return this.resaleAuthorizationFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProductFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.saaSProductFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiProductFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.offerFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerProductFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.resaleAuthorizationFilters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityTypeFilters)) {
            return false;
        }
        EntityTypeFilters other = (EntityTypeFilters)obj;
        return Objects.equals(this.dataProductFilters(), other.dataProductFilters()) && Objects.equals(this.saaSProductFilters(), other.saaSProductFilters()) && Objects.equals(this.amiProductFilters(), other.amiProductFilters()) && Objects.equals(this.offerFilters(), other.offerFilters()) && Objects.equals(this.containerProductFilters(), other.containerProductFilters()) && Objects.equals(this.resaleAuthorizationFilters(), other.resaleAuthorizationFilters());
    }

    public final String toString() {
        return ToString.builder((String)"EntityTypeFilters").add("DataProductFilters", (Object)this.dataProductFilters()).add("SaaSProductFilters", (Object)this.saaSProductFilters()).add("AmiProductFilters", (Object)this.amiProductFilters()).add("OfferFilters", (Object)this.offerFilters()).add("ContainerProductFilters", (Object)this.containerProductFilters()).add("ResaleAuthorizationFilters", (Object)this.resaleAuthorizationFilters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataProductFilters": {
                return Optional.ofNullable(clazz.cast(this.dataProductFilters()));
            }
            case "SaaSProductFilters": {
                return Optional.ofNullable(clazz.cast(this.saaSProductFilters()));
            }
            case "AmiProductFilters": {
                return Optional.ofNullable(clazz.cast(this.amiProductFilters()));
            }
            case "OfferFilters": {
                return Optional.ofNullable(clazz.cast(this.offerFilters()));
            }
            case "ContainerProductFilters": {
                return Optional.ofNullable(clazz.cast(this.containerProductFilters()));
            }
            case "ResaleAuthorizationFilters": {
                return Optional.ofNullable(clazz.cast(this.resaleAuthorizationFilters()));
            }
        }
        return Optional.empty();
    }

    public static EntityTypeFilters fromDataProductFilters(DataProductFilters dataProductFilters) {
        return (EntityTypeFilters)EntityTypeFilters.builder().dataProductFilters(dataProductFilters).build();
    }

    public static EntityTypeFilters fromDataProductFilters(Consumer<DataProductFilters.Builder> dataProductFilters) {
        DataProductFilters.Builder builder = DataProductFilters.builder();
        dataProductFilters.accept(builder);
        return EntityTypeFilters.fromDataProductFilters((DataProductFilters)builder.build());
    }

    public static EntityTypeFilters fromSaaSProductFilters(SaaSProductFilters saaSProductFilters) {
        return (EntityTypeFilters)EntityTypeFilters.builder().saaSProductFilters(saaSProductFilters).build();
    }

    public static EntityTypeFilters fromSaaSProductFilters(Consumer<SaaSProductFilters.Builder> saaSProductFilters) {
        SaaSProductFilters.Builder builder = SaaSProductFilters.builder();
        saaSProductFilters.accept(builder);
        return EntityTypeFilters.fromSaaSProductFilters((SaaSProductFilters)builder.build());
    }

    public static EntityTypeFilters fromAmiProductFilters(AmiProductFilters amiProductFilters) {
        return (EntityTypeFilters)EntityTypeFilters.builder().amiProductFilters(amiProductFilters).build();
    }

    public static EntityTypeFilters fromAmiProductFilters(Consumer<AmiProductFilters.Builder> amiProductFilters) {
        AmiProductFilters.Builder builder = AmiProductFilters.builder();
        amiProductFilters.accept(builder);
        return EntityTypeFilters.fromAmiProductFilters((AmiProductFilters)builder.build());
    }

    public static EntityTypeFilters fromOfferFilters(OfferFilters offerFilters) {
        return (EntityTypeFilters)EntityTypeFilters.builder().offerFilters(offerFilters).build();
    }

    public static EntityTypeFilters fromOfferFilters(Consumer<OfferFilters.Builder> offerFilters) {
        OfferFilters.Builder builder = OfferFilters.builder();
        offerFilters.accept(builder);
        return EntityTypeFilters.fromOfferFilters((OfferFilters)builder.build());
    }

    public static EntityTypeFilters fromContainerProductFilters(ContainerProductFilters containerProductFilters) {
        return (EntityTypeFilters)EntityTypeFilters.builder().containerProductFilters(containerProductFilters).build();
    }

    public static EntityTypeFilters fromContainerProductFilters(Consumer<ContainerProductFilters.Builder> containerProductFilters) {
        ContainerProductFilters.Builder builder = ContainerProductFilters.builder();
        containerProductFilters.accept(builder);
        return EntityTypeFilters.fromContainerProductFilters((ContainerProductFilters)builder.build());
    }

    public static EntityTypeFilters fromResaleAuthorizationFilters(ResaleAuthorizationFilters resaleAuthorizationFilters) {
        return (EntityTypeFilters)EntityTypeFilters.builder().resaleAuthorizationFilters(resaleAuthorizationFilters).build();
    }

    public static EntityTypeFilters fromResaleAuthorizationFilters(Consumer<ResaleAuthorizationFilters.Builder> resaleAuthorizationFilters) {
        ResaleAuthorizationFilters.Builder builder = ResaleAuthorizationFilters.builder();
        resaleAuthorizationFilters.accept(builder);
        return EntityTypeFilters.fromResaleAuthorizationFilters((ResaleAuthorizationFilters)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EntityTypeFilters, T> g) {
        return obj -> g.apply((EntityTypeFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DATA_PRODUCT_FILTERS,
        SAA_S_PRODUCT_FILTERS,
        AMI_PRODUCT_FILTERS,
        OFFER_FILTERS,
        CONTAINER_PRODUCT_FILTERS,
        RESALE_AUTHORIZATION_FILTERS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private DataProductFilters dataProductFilters;
        private SaaSProductFilters saaSProductFilters;
        private AmiProductFilters amiProductFilters;
        private OfferFilters offerFilters;
        private ContainerProductFilters containerProductFilters;
        private ResaleAuthorizationFilters resaleAuthorizationFilters;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EntityTypeFilters model) {
            this.dataProductFilters(model.dataProductFilters);
            this.saaSProductFilters(model.saaSProductFilters);
            this.amiProductFilters(model.amiProductFilters);
            this.offerFilters(model.offerFilters);
            this.containerProductFilters(model.containerProductFilters);
            this.resaleAuthorizationFilters(model.resaleAuthorizationFilters);
        }

        public final DataProductFilters.Builder getDataProductFilters() {
            return this.dataProductFilters != null ? this.dataProductFilters.toBuilder() : null;
        }

        public final void setDataProductFilters(DataProductFilters.BuilderImpl dataProductFilters) {
            DataProductFilters oldValue = this.dataProductFilters;
            this.dataProductFilters = dataProductFilters != null ? dataProductFilters.build() : null;
            this.handleUnionValueChange(Type.DATA_PRODUCT_FILTERS, oldValue, this.dataProductFilters);
        }

        @Override
        public final Builder dataProductFilters(DataProductFilters dataProductFilters) {
            DataProductFilters oldValue = this.dataProductFilters;
            this.dataProductFilters = dataProductFilters;
            this.handleUnionValueChange(Type.DATA_PRODUCT_FILTERS, oldValue, this.dataProductFilters);
            return this;
        }

        public final SaaSProductFilters.Builder getSaaSProductFilters() {
            return this.saaSProductFilters != null ? this.saaSProductFilters.toBuilder() : null;
        }

        public final void setSaaSProductFilters(SaaSProductFilters.BuilderImpl saaSProductFilters) {
            SaaSProductFilters oldValue = this.saaSProductFilters;
            this.saaSProductFilters = saaSProductFilters != null ? saaSProductFilters.build() : null;
            this.handleUnionValueChange(Type.SAA_S_PRODUCT_FILTERS, oldValue, this.saaSProductFilters);
        }

        @Override
        public final Builder saaSProductFilters(SaaSProductFilters saaSProductFilters) {
            SaaSProductFilters oldValue = this.saaSProductFilters;
            this.saaSProductFilters = saaSProductFilters;
            this.handleUnionValueChange(Type.SAA_S_PRODUCT_FILTERS, oldValue, this.saaSProductFilters);
            return this;
        }

        public final AmiProductFilters.Builder getAmiProductFilters() {
            return this.amiProductFilters != null ? this.amiProductFilters.toBuilder() : null;
        }

        public final void setAmiProductFilters(AmiProductFilters.BuilderImpl amiProductFilters) {
            AmiProductFilters oldValue = this.amiProductFilters;
            this.amiProductFilters = amiProductFilters != null ? amiProductFilters.build() : null;
            this.handleUnionValueChange(Type.AMI_PRODUCT_FILTERS, oldValue, this.amiProductFilters);
        }

        @Override
        public final Builder amiProductFilters(AmiProductFilters amiProductFilters) {
            AmiProductFilters oldValue = this.amiProductFilters;
            this.amiProductFilters = amiProductFilters;
            this.handleUnionValueChange(Type.AMI_PRODUCT_FILTERS, oldValue, this.amiProductFilters);
            return this;
        }

        public final OfferFilters.Builder getOfferFilters() {
            return this.offerFilters != null ? this.offerFilters.toBuilder() : null;
        }

        public final void setOfferFilters(OfferFilters.BuilderImpl offerFilters) {
            OfferFilters oldValue = this.offerFilters;
            this.offerFilters = offerFilters != null ? offerFilters.build() : null;
            this.handleUnionValueChange(Type.OFFER_FILTERS, oldValue, this.offerFilters);
        }

        @Override
        public final Builder offerFilters(OfferFilters offerFilters) {
            OfferFilters oldValue = this.offerFilters;
            this.offerFilters = offerFilters;
            this.handleUnionValueChange(Type.OFFER_FILTERS, oldValue, this.offerFilters);
            return this;
        }

        public final ContainerProductFilters.Builder getContainerProductFilters() {
            return this.containerProductFilters != null ? this.containerProductFilters.toBuilder() : null;
        }

        public final void setContainerProductFilters(ContainerProductFilters.BuilderImpl containerProductFilters) {
            ContainerProductFilters oldValue = this.containerProductFilters;
            this.containerProductFilters = containerProductFilters != null ? containerProductFilters.build() : null;
            this.handleUnionValueChange(Type.CONTAINER_PRODUCT_FILTERS, oldValue, this.containerProductFilters);
        }

        @Override
        public final Builder containerProductFilters(ContainerProductFilters containerProductFilters) {
            ContainerProductFilters oldValue = this.containerProductFilters;
            this.containerProductFilters = containerProductFilters;
            this.handleUnionValueChange(Type.CONTAINER_PRODUCT_FILTERS, oldValue, this.containerProductFilters);
            return this;
        }

        public final ResaleAuthorizationFilters.Builder getResaleAuthorizationFilters() {
            return this.resaleAuthorizationFilters != null ? this.resaleAuthorizationFilters.toBuilder() : null;
        }

        public final void setResaleAuthorizationFilters(ResaleAuthorizationFilters.BuilderImpl resaleAuthorizationFilters) {
            ResaleAuthorizationFilters oldValue = this.resaleAuthorizationFilters;
            this.resaleAuthorizationFilters = resaleAuthorizationFilters != null ? resaleAuthorizationFilters.build() : null;
            this.handleUnionValueChange(Type.RESALE_AUTHORIZATION_FILTERS, oldValue, this.resaleAuthorizationFilters);
        }

        @Override
        public final Builder resaleAuthorizationFilters(ResaleAuthorizationFilters resaleAuthorizationFilters) {
            ResaleAuthorizationFilters oldValue = this.resaleAuthorizationFilters;
            this.resaleAuthorizationFilters = resaleAuthorizationFilters;
            this.handleUnionValueChange(Type.RESALE_AUTHORIZATION_FILTERS, oldValue, this.resaleAuthorizationFilters);
            return this;
        }

        public EntityTypeFilters build() {
            return new EntityTypeFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityTypeFilters> {
        public Builder dataProductFilters(DataProductFilters var1);

        default public Builder dataProductFilters(Consumer<DataProductFilters.Builder> dataProductFilters) {
            return this.dataProductFilters((DataProductFilters)((DataProductFilters.Builder)DataProductFilters.builder().applyMutation(dataProductFilters)).build());
        }

        public Builder saaSProductFilters(SaaSProductFilters var1);

        default public Builder saaSProductFilters(Consumer<SaaSProductFilters.Builder> saaSProductFilters) {
            return this.saaSProductFilters((SaaSProductFilters)((SaaSProductFilters.Builder)SaaSProductFilters.builder().applyMutation(saaSProductFilters)).build());
        }

        public Builder amiProductFilters(AmiProductFilters var1);

        default public Builder amiProductFilters(Consumer<AmiProductFilters.Builder> amiProductFilters) {
            return this.amiProductFilters((AmiProductFilters)((AmiProductFilters.Builder)AmiProductFilters.builder().applyMutation(amiProductFilters)).build());
        }

        public Builder offerFilters(OfferFilters var1);

        default public Builder offerFilters(Consumer<OfferFilters.Builder> offerFilters) {
            return this.offerFilters((OfferFilters)((OfferFilters.Builder)OfferFilters.builder().applyMutation(offerFilters)).build());
        }

        public Builder containerProductFilters(ContainerProductFilters var1);

        default public Builder containerProductFilters(Consumer<ContainerProductFilters.Builder> containerProductFilters) {
            return this.containerProductFilters((ContainerProductFilters)((ContainerProductFilters.Builder)ContainerProductFilters.builder().applyMutation(containerProductFilters)).build());
        }

        public Builder resaleAuthorizationFilters(ResaleAuthorizationFilters var1);

        default public Builder resaleAuthorizationFilters(Consumer<ResaleAuthorizationFilters.Builder> resaleAuthorizationFilters) {
            return this.resaleAuthorizationFilters((ResaleAuthorizationFilters)((ResaleAuthorizationFilters.Builder)ResaleAuthorizationFilters.builder().applyMutation(resaleAuthorizationFilters)).build());
        }
    }
}

