/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QueryNetwork {
    ETHEREUM_MAINNET("ETHEREUM_MAINNET"),
    ETHEREUM_SEPOLIA_TESTNET("ETHEREUM_SEPOLIA_TESTNET"),
    BITCOIN_MAINNET("BITCOIN_MAINNET"),
    BITCOIN_TESTNET("BITCOIN_TESTNET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QueryNetwork> VALUE_MAP;
    private final String value;

    private QueryNetwork(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QueryNetwork fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QueryNetwork> knownValues() {
        EnumSet<QueryNetwork> knownValues = EnumSet.allOf(QueryNetwork.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QueryNetwork.class, QueryNetwork::toString);
    }
}

