/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceInputItem;
import software.amazon.awssdk.services.managedblockchainquery.model.GetTokenBalanceInputListCopier;
import software.amazon.awssdk.services.managedblockchainquery.model.ManagedBlockchainQueryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetTokenBalanceRequest
extends ManagedBlockchainQueryRequest
implements ToCopyableBuilder<Builder, BatchGetTokenBalanceRequest> {
    private static final SdkField<List<BatchGetTokenBalanceInputItem>> GET_TOKEN_BALANCE_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("getTokenBalanceInputs").getter(BatchGetTokenBalanceRequest.getter(BatchGetTokenBalanceRequest::getTokenBalanceInputs)).setter(BatchGetTokenBalanceRequest.setter(Builder::getTokenBalanceInputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("getTokenBalanceInputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetTokenBalanceInputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GET_TOKEN_BALANCE_INPUTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("getTokenBalanceInputs", GET_TOKEN_BALANCE_INPUTS_FIELD);
        }
    });
    private final List<BatchGetTokenBalanceInputItem> getTokenBalanceInputs;

    private BatchGetTokenBalanceRequest(BuilderImpl builder) {
        super(builder);
        this.getTokenBalanceInputs = builder.getTokenBalanceInputs;
    }

    public final boolean hasGetTokenBalanceInputs() {
        return this.getTokenBalanceInputs != null && !(this.getTokenBalanceInputs instanceof SdkAutoConstructList);
    }

    public final List<BatchGetTokenBalanceInputItem> getTokenBalanceInputs() {
        return this.getTokenBalanceInputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGetTokenBalanceInputs() ? this.getTokenBalanceInputs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTokenBalanceRequest)) {
            return false;
        }
        BatchGetTokenBalanceRequest other = (BatchGetTokenBalanceRequest)((Object)obj);
        return this.hasGetTokenBalanceInputs() == other.hasGetTokenBalanceInputs() && Objects.equals(this.getTokenBalanceInputs(), other.getTokenBalanceInputs());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetTokenBalanceRequest").add("GetTokenBalanceInputs", this.hasGetTokenBalanceInputs() ? this.getTokenBalanceInputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "getTokenBalanceInputs": {
                return Optional.ofNullable(clazz.cast(this.getTokenBalanceInputs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTokenBalanceRequest, T> g) {
        return obj -> g.apply((BatchGetTokenBalanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainQueryRequest.BuilderImpl
    implements Builder {
        private List<BatchGetTokenBalanceInputItem> getTokenBalanceInputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTokenBalanceRequest model) {
            super(model);
            this.getTokenBalanceInputs(model.getTokenBalanceInputs);
        }

        public final List<BatchGetTokenBalanceInputItem.Builder> getGetTokenBalanceInputs() {
            List<BatchGetTokenBalanceInputItem.Builder> result = GetTokenBalanceInputListCopier.copyToBuilder(this.getTokenBalanceInputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGetTokenBalanceInputs(Collection<BatchGetTokenBalanceInputItem.BuilderImpl> getTokenBalanceInputs) {
            this.getTokenBalanceInputs = GetTokenBalanceInputListCopier.copyFromBuilder(getTokenBalanceInputs);
        }

        @Override
        public final Builder getTokenBalanceInputs(Collection<BatchGetTokenBalanceInputItem> getTokenBalanceInputs) {
            this.getTokenBalanceInputs = GetTokenBalanceInputListCopier.copy(getTokenBalanceInputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder getTokenBalanceInputs(BatchGetTokenBalanceInputItem ... getTokenBalanceInputs) {
            this.getTokenBalanceInputs(Arrays.asList(getTokenBalanceInputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder getTokenBalanceInputs(Consumer<BatchGetTokenBalanceInputItem.Builder> ... getTokenBalanceInputs) {
            this.getTokenBalanceInputs(Stream.of(getTokenBalanceInputs).map(c -> (BatchGetTokenBalanceInputItem)((BatchGetTokenBalanceInputItem.Builder)BatchGetTokenBalanceInputItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetTokenBalanceRequest build() {
            return new BatchGetTokenBalanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ManagedBlockchainQueryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetTokenBalanceRequest> {
        public Builder getTokenBalanceInputs(Collection<BatchGetTokenBalanceInputItem> var1);

        public Builder getTokenBalanceInputs(BatchGetTokenBalanceInputItem ... var1);

        public Builder getTokenBalanceInputs(Consumer<BatchGetTokenBalanceInputItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

