/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.ErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnprocessedAccount
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UnprocessedAccount> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(UnprocessedAccount.getter(UnprocessedAccount::accountId)).setter(UnprocessedAccount.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(UnprocessedAccount.getter(UnprocessedAccount::errorCodeAsString)).setter(UnprocessedAccount.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(UnprocessedAccount.getter(UnprocessedAccount::errorMessage)).setter(UnprocessedAccount.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accountId", ACCOUNT_ID_FIELD);
            this.put("errorCode", ERROR_CODE_FIELD);
            this.put("errorMessage", ERROR_MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String errorCode;
    private final String errorMessage;

    private UnprocessedAccount(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final ErrorCode errorCode() {
        return ErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedAccount)) {
            return false;
        }
        UnprocessedAccount other = (UnprocessedAccount)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"UnprocessedAccount").add("AccountId", (Object)this.accountId()).add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UnprocessedAccount, T> g) {
        return obj -> g.apply((UnprocessedAccount)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedAccount model) {
            this.accountId(model.accountId);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public UnprocessedAccount build() {
            return new UnprocessedAccount(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UnprocessedAccount> {
        public Builder accountId(String var1);

        public Builder errorCode(String var1);

        public Builder errorCode(ErrorCode var1);

        public Builder errorMessage(String var1);
    }
}

