/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TreatMissingData {
    BREACHING("breaching"),
    NOT_BREACHING("notBreaching"),
    IGNORE("ignore"),
    MISSING("missing"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TreatMissingData> VALUE_MAP;
    private final String value;

    private TreatMissingData(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TreatMissingData fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TreatMissingData> knownValues() {
        EnumSet<TreatMissingData> knownValues = EnumSet.allOf(TreatMissingData.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TreatMissingData.class, TreatMissingData::toString);
    }
}

