/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContainerServiceProtocol {
    HTTP("HTTP"),
    HTTPS("HTTPS"),
    TCP("TCP"),
    UDP("UDP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContainerServiceProtocol> VALUE_MAP;
    private final String value;

    private ContainerServiceProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerServiceProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerServiceProtocol> knownValues() {
        EnumSet<ContainerServiceProtocol> knownValues = EnumSet.allOf(ContainerServiceProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContainerServiceProtocol.class, ContainerServiceProtocol::toString);
    }
}

