/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.endpoints.internal;

import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.services.lexruntimev2.endpoints.internal.Outputs;

@SdkInternalApi
public class RulePartition {
    private static final String DNS_SUFFIX = "dnsSuffix";
    private static final String DUAL_STACK_DNS_SUFFIX = "dualStackDnsSuffix";
    private static final String SUPPORTS_FIPS = "supportsFIPS";
    private static final String SUPPORTS_DUAL_STACK = "supportsDualStack";
    private static final String IMPLICIT_GLOBAL_REGION = "implicitGlobalRegion";
    private final String name;
    private final String dnsSuffix;
    private final String dualStackDnsSuffix;
    private final boolean supportsFips;
    private final boolean supportsDualStack;
    private final String implicitGlobalRegion;

    private RulePartition(Builder builder) {
        this.name = builder.name;
        this.dnsSuffix = builder.dnsSuffix;
        this.dualStackDnsSuffix = builder.dualStackDnsSuffix;
        this.supportsFips = builder.supportsFips;
        this.supportsDualStack = builder.supportsDualStack;
        this.implicitGlobalRegion = builder.implicitGlobalRegion;
    }

    public String name() {
        return this.name;
    }

    public String dnsSuffix() {
        return this.dnsSuffix;
    }

    public String dualStackDnsSuffix() {
        return this.dualStackDnsSuffix;
    }

    public boolean supportsFips() {
        return this.supportsFips;
    }

    public boolean supportsFIPS() {
        return this.supportsFips;
    }

    public boolean supportsDualStack() {
        return this.supportsDualStack;
    }

    public String implicitGlobalRegion() {
        return this.implicitGlobalRegion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RulePartition that = (RulePartition)o;
        return this.supportsFips == that.supportsFips && this.supportsDualStack == that.supportsDualStack && Objects.equals(this.name, that.name) && Objects.equals(this.dnsSuffix, that.dnsSuffix) && Objects.equals(this.dualStackDnsSuffix, that.dualStackDnsSuffix) && Objects.equals(this.implicitGlobalRegion, that.implicitGlobalRegion);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dnsSuffix, this.dualStackDnsSuffix, this.supportsFips, this.supportsDualStack, this.implicitGlobalRegion);
    }

    public static Builder builder() {
        return new Builder();
    }

    static RulePartition from(String name, Outputs outputs) {
        return RulePartition.builder().name(name).dnsSuffix(outputs.dnsSuffix()).dualStackDnsSuffix(outputs.dualStackDnsSuffix()).supportsFips(outputs.supportsFips()).supportsDualStack(outputs.supportsDualStack()).implicitGlobalRegion(outputs.implicitGlobalRegion()).build();
    }

    public static RulePartition fromNode(String name, JsonNode node) {
        JsonNode implicitGlobalRegion;
        JsonNode supportsDualStack;
        JsonNode supportsFips;
        JsonNode dualStackDnsSuffix;
        Map objNode = node.asObject();
        Builder b = RulePartition.builder();
        b.name(name);
        JsonNode dnsSuffix = (JsonNode)objNode.get(DNS_SUFFIX);
        if (dnsSuffix != null) {
            b.dnsSuffix(dnsSuffix.asString());
        }
        if ((dualStackDnsSuffix = (JsonNode)objNode.get(DUAL_STACK_DNS_SUFFIX)) != null) {
            b.dualStackDnsSuffix(dualStackDnsSuffix.asString());
        }
        if ((supportsFips = (JsonNode)objNode.get(SUPPORTS_FIPS)) != null) {
            b.supportsFips(supportsFips.asBoolean());
        }
        if ((supportsDualStack = (JsonNode)objNode.get(SUPPORTS_DUAL_STACK)) != null) {
            b.supportsDualStack(supportsDualStack.asBoolean());
        }
        if ((implicitGlobalRegion = (JsonNode)objNode.get(IMPLICIT_GLOBAL_REGION)) != null) {
            b.implicitGlobalRegion(implicitGlobalRegion.asString());
        }
        return b.build();
    }

    public static class Builder {
        private String name;
        private String dnsSuffix;
        private String dualStackDnsSuffix;
        private boolean supportsFips;
        private boolean supportsDualStack;
        private String implicitGlobalRegion;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder dnsSuffix(String dnsSuffix) {
            this.dnsSuffix = dnsSuffix;
            return this;
        }

        public Builder dualStackDnsSuffix(String dualStackDnsSuffix) {
            this.dualStackDnsSuffix = dualStackDnsSuffix;
            return this;
        }

        public Builder supportsFips(boolean supportsFips) {
            this.supportsFips = supportsFips;
            return this;
        }

        public Builder supportsDualStack(boolean supportsDualStack) {
            this.supportsDualStack = supportsDualStack;
            return this;
        }

        public Builder implicitGlobalRegion(String implicitGlobalRegion) {
            this.implicitGlobalRegion = implicitGlobalRegion;
            return this;
        }

        public RulePartition build() {
            return new RulePartition(this);
        }
    }
}

