/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse;

public class ListImportsPublisher
implements SdkPublisher<ListImportsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListImportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImportsPublisher(LexModelsV2AsyncClient client, ListImportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImportsPublisher(LexModelsV2AsyncClient client, ListImportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListImportsResponseFetcher
    implements AsyncPageFetcher<ListImportsResponse> {
        private ListImportsResponseFetcher() {
        }

        public boolean hasNextPage(ListImportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImportsResponse> nextPage(ListImportsResponse previousPage) {
            if (previousPage == null) {
                return ListImportsPublisher.this.client.listImports(ListImportsPublisher.this.firstRequest);
            }
            return ListImportsPublisher.this.client.listImports((ListImportsRequest)((Object)ListImportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

