/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.ExactResponseFields;
import software.amazon.awssdk.services.lexmodelsv2.model.OSIncludeFieldsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpensearchConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpensearchConfiguration> {
    private static final SdkField<String> DOMAIN_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainEndpoint").getter(OpensearchConfiguration.getter(OpensearchConfiguration::domainEndpoint)).setter(OpensearchConfiguration.setter(Builder::domainEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainEndpoint").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexName").getter(OpensearchConfiguration.getter(OpensearchConfiguration::indexName)).setter(OpensearchConfiguration.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()}).build();
    private static final SdkField<Boolean> EXACT_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("exactResponse").getter(OpensearchConfiguration.getter(OpensearchConfiguration::exactResponse)).setter(OpensearchConfiguration.setter(Builder::exactResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exactResponse").build()}).build();
    private static final SdkField<ExactResponseFields> EXACT_RESPONSE_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exactResponseFields").getter(OpensearchConfiguration.getter(OpensearchConfiguration::exactResponseFields)).setter(OpensearchConfiguration.setter(Builder::exactResponseFields)).constructor(ExactResponseFields::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exactResponseFields").build()}).build();
    private static final SdkField<List<String>> INCLUDE_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("includeFields").getter(OpensearchConfiguration.getter(OpensearchConfiguration::includeFields)).setter(OpensearchConfiguration.setter(Builder::includeFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ENDPOINT_FIELD, INDEX_NAME_FIELD, EXACT_RESPONSE_FIELD, EXACT_RESPONSE_FIELDS_FIELD, INCLUDE_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("domainEndpoint", DOMAIN_ENDPOINT_FIELD);
            this.put("indexName", INDEX_NAME_FIELD);
            this.put("exactResponse", EXACT_RESPONSE_FIELD);
            this.put("exactResponseFields", EXACT_RESPONSE_FIELDS_FIELD);
            this.put("includeFields", INCLUDE_FIELDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String domainEndpoint;
    private final String indexName;
    private final Boolean exactResponse;
    private final ExactResponseFields exactResponseFields;
    private final List<String> includeFields;

    private OpensearchConfiguration(BuilderImpl builder) {
        this.domainEndpoint = builder.domainEndpoint;
        this.indexName = builder.indexName;
        this.exactResponse = builder.exactResponse;
        this.exactResponseFields = builder.exactResponseFields;
        this.includeFields = builder.includeFields;
    }

    public final String domainEndpoint() {
        return this.domainEndpoint;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final Boolean exactResponse() {
        return this.exactResponse;
    }

    public final ExactResponseFields exactResponseFields() {
        return this.exactResponseFields;
    }

    public final boolean hasIncludeFields() {
        return this.includeFields != null && !(this.includeFields instanceof SdkAutoConstructList);
    }

    public final List<String> includeFields() {
        return this.includeFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.exactResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.exactResponseFields());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeFields() ? this.includeFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpensearchConfiguration)) {
            return false;
        }
        OpensearchConfiguration other = (OpensearchConfiguration)obj;
        return Objects.equals(this.domainEndpoint(), other.domainEndpoint()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.exactResponse(), other.exactResponse()) && Objects.equals(this.exactResponseFields(), other.exactResponseFields()) && this.hasIncludeFields() == other.hasIncludeFields() && Objects.equals(this.includeFields(), other.includeFields());
    }

    public final String toString() {
        return ToString.builder((String)"OpensearchConfiguration").add("DomainEndpoint", (Object)this.domainEndpoint()).add("IndexName", (Object)this.indexName()).add("ExactResponse", (Object)this.exactResponse()).add("ExactResponseFields", (Object)this.exactResponseFields()).add("IncludeFields", this.hasIncludeFields() ? this.includeFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainEndpoint": {
                return Optional.ofNullable(clazz.cast(this.domainEndpoint()));
            }
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "exactResponse": {
                return Optional.ofNullable(clazz.cast(this.exactResponse()));
            }
            case "exactResponseFields": {
                return Optional.ofNullable(clazz.cast(this.exactResponseFields()));
            }
            case "includeFields": {
                return Optional.ofNullable(clazz.cast(this.includeFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OpensearchConfiguration, T> g) {
        return obj -> g.apply((OpensearchConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainEndpoint;
        private String indexName;
        private Boolean exactResponse;
        private ExactResponseFields exactResponseFields;
        private List<String> includeFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpensearchConfiguration model) {
            this.domainEndpoint(model.domainEndpoint);
            this.indexName(model.indexName);
            this.exactResponse(model.exactResponse);
            this.exactResponseFields(model.exactResponseFields);
            this.includeFields(model.includeFields);
        }

        public final String getDomainEndpoint() {
            return this.domainEndpoint;
        }

        public final void setDomainEndpoint(String domainEndpoint) {
            this.domainEndpoint = domainEndpoint;
        }

        @Override
        public final Builder domainEndpoint(String domainEndpoint) {
            this.domainEndpoint = domainEndpoint;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final Boolean getExactResponse() {
            return this.exactResponse;
        }

        public final void setExactResponse(Boolean exactResponse) {
            this.exactResponse = exactResponse;
        }

        @Override
        public final Builder exactResponse(Boolean exactResponse) {
            this.exactResponse = exactResponse;
            return this;
        }

        public final ExactResponseFields.Builder getExactResponseFields() {
            return this.exactResponseFields != null ? this.exactResponseFields.toBuilder() : null;
        }

        public final void setExactResponseFields(ExactResponseFields.BuilderImpl exactResponseFields) {
            this.exactResponseFields = exactResponseFields != null ? exactResponseFields.build() : null;
        }

        @Override
        public final Builder exactResponseFields(ExactResponseFields exactResponseFields) {
            this.exactResponseFields = exactResponseFields;
            return this;
        }

        public final Collection<String> getIncludeFields() {
            if (this.includeFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeFields;
        }

        public final void setIncludeFields(Collection<String> includeFields) {
            this.includeFields = OSIncludeFieldsCopier.copy(includeFields);
        }

        @Override
        public final Builder includeFields(Collection<String> includeFields) {
            this.includeFields = OSIncludeFieldsCopier.copy(includeFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeFields(String ... includeFields) {
            this.includeFields(Arrays.asList(includeFields));
            return this;
        }

        public OpensearchConfiguration build() {
            return new OpensearchConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpensearchConfiguration> {
        public Builder domainEndpoint(String var1);

        public Builder indexName(String var1);

        public Builder exactResponse(Boolean var1);

        public Builder exactResponseFields(ExactResponseFields var1);

        default public Builder exactResponseFields(Consumer<ExactResponseFields.Builder> exactResponseFields) {
            return this.exactResponseFields((ExactResponseFields)((ExactResponseFields.Builder)ExactResponseFields.builder().applyMutation(exactResponseFields)).build());
        }

        public Builder includeFields(Collection<String> var1);

        public Builder includeFields(String ... var1);
    }
}

