/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyItem;
import software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyItemsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.FailedCustomVocabularyItem;
import software.amazon.awssdk.services.lexmodelsv2.model.FailedCustomVocabularyItemsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteCustomVocabularyItemResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, BatchDeleteCustomVocabularyItemResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(BatchDeleteCustomVocabularyItemResponse.getter(BatchDeleteCustomVocabularyItemResponse::botId)).setter(BatchDeleteCustomVocabularyItemResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(BatchDeleteCustomVocabularyItemResponse.getter(BatchDeleteCustomVocabularyItemResponse::botVersion)).setter(BatchDeleteCustomVocabularyItemResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(BatchDeleteCustomVocabularyItemResponse.getter(BatchDeleteCustomVocabularyItemResponse::localeId)).setter(BatchDeleteCustomVocabularyItemResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<List<FailedCustomVocabularyItem>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchDeleteCustomVocabularyItemResponse.getter(BatchDeleteCustomVocabularyItemResponse::errors)).setter(BatchDeleteCustomVocabularyItemResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedCustomVocabularyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CustomVocabularyItem>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resources").getter(BatchDeleteCustomVocabularyItemResponse.getter(BatchDeleteCustomVocabularyItemResponse::resources)).setter(BatchDeleteCustomVocabularyItemResponse.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomVocabularyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, ERRORS_FIELD, RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("botId", BOT_ID_FIELD);
            this.put("botVersion", BOT_VERSION_FIELD);
            this.put("localeId", LOCALE_ID_FIELD);
            this.put("errors", ERRORS_FIELD);
            this.put("resources", RESOURCES_FIELD);
        }
    });
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final List<FailedCustomVocabularyItem> errors;
    private final List<CustomVocabularyItem> resources;

    private BatchDeleteCustomVocabularyItemResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.errors = builder.errors;
        this.resources = builder.resources;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<FailedCustomVocabularyItem> errors() {
        return this.errors;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<CustomVocabularyItem> resources() {
        return this.resources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteCustomVocabularyItemResponse)) {
            return false;
        }
        BatchDeleteCustomVocabularyItemResponse other = (BatchDeleteCustomVocabularyItemResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteCustomVocabularyItemResponse").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("Errors", this.hasErrors() ? this.errors() : null).add("Resources", this.hasResources() ? this.resources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteCustomVocabularyItemResponse, T> g) {
        return obj -> g.apply((BatchDeleteCustomVocabularyItemResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String localeId;
        private List<FailedCustomVocabularyItem> errors = DefaultSdkAutoConstructList.getInstance();
        private List<CustomVocabularyItem> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteCustomVocabularyItemResponse model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.errors(model.errors);
            this.resources(model.resources);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final List<FailedCustomVocabularyItem.Builder> getErrors() {
            List<FailedCustomVocabularyItem.Builder> result = FailedCustomVocabularyItemsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<FailedCustomVocabularyItem.BuilderImpl> errors) {
            this.errors = FailedCustomVocabularyItemsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<FailedCustomVocabularyItem> errors) {
            this.errors = FailedCustomVocabularyItemsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(FailedCustomVocabularyItem ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<FailedCustomVocabularyItem.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (FailedCustomVocabularyItem)((FailedCustomVocabularyItem.Builder)FailedCustomVocabularyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CustomVocabularyItem.Builder> getResources() {
            List<CustomVocabularyItem.Builder> result = CustomVocabularyItemsCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<CustomVocabularyItem.BuilderImpl> resources) {
            this.resources = CustomVocabularyItemsCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<CustomVocabularyItem> resources) {
            this.resources = CustomVocabularyItemsCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(CustomVocabularyItem ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<CustomVocabularyItem.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (CustomVocabularyItem)((CustomVocabularyItem.Builder)CustomVocabularyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDeleteCustomVocabularyItemResponse build() {
            return new BatchDeleteCustomVocabularyItemResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteCustomVocabularyItemResponse> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder errors(Collection<FailedCustomVocabularyItem> var1);

        public Builder errors(FailedCustomVocabularyItem ... var1);

        public Builder errors(Consumer<FailedCustomVocabularyItem.Builder> ... var1);

        public Builder resources(Collection<CustomVocabularyItem> var1);

        public Builder resources(CustomVocabularyItem ... var1);

        public Builder resources(Consumer<CustomVocabularyItem.Builder> ... var1);
    }
}

