/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.RecorderStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LastRecorderStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LastRecorderStatus> {
    private static final SdkField<String> JOB_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatusDetails").getter(LastRecorderStatus.getter(LastRecorderStatus::jobStatusDetails)).setter(LastRecorderStatus.setter(Builder::jobStatusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatusDetails").build()}).build();
    private static final SdkField<Instant> LAST_COLLECTED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastCollectedTime").getter(LastRecorderStatus.getter(LastRecorderStatus::lastCollectedTime)).setter(LastRecorderStatus.setter(Builder::lastCollectedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastCollectedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(LastRecorderStatus.getter(LastRecorderStatus::lastUpdatedTime)).setter(LastRecorderStatus.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> RECORDER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecorderStatus").getter(LastRecorderStatus.getter(LastRecorderStatus::recorderStatusAsString)).setter(LastRecorderStatus.setter(Builder::recorderStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecorderStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_DETAILS_FIELD, LAST_COLLECTED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, RECORDER_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("JobStatusDetails", JOB_STATUS_DETAILS_FIELD);
            this.put("LastCollectedTime", LAST_COLLECTED_TIME_FIELD);
            this.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
            this.put("RecorderStatus", RECORDER_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String jobStatusDetails;
    private final Instant lastCollectedTime;
    private final Instant lastUpdatedTime;
    private final String recorderStatus;

    private LastRecorderStatus(BuilderImpl builder) {
        this.jobStatusDetails = builder.jobStatusDetails;
        this.lastCollectedTime = builder.lastCollectedTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.recorderStatus = builder.recorderStatus;
    }

    public final String jobStatusDetails() {
        return this.jobStatusDetails;
    }

    public final Instant lastCollectedTime() {
        return this.lastCollectedTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final RecorderStatus recorderStatus() {
        return RecorderStatus.fromValue(this.recorderStatus);
    }

    public final String recorderStatusAsString() {
        return this.recorderStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastCollectedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recorderStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastRecorderStatus)) {
            return false;
        }
        LastRecorderStatus other = (LastRecorderStatus)obj;
        return Objects.equals(this.jobStatusDetails(), other.jobStatusDetails()) && Objects.equals(this.lastCollectedTime(), other.lastCollectedTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.recorderStatusAsString(), other.recorderStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LastRecorderStatus").add("JobStatusDetails", (Object)this.jobStatusDetails()).add("LastCollectedTime", (Object)this.lastCollectedTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("RecorderStatus", (Object)this.recorderStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.jobStatusDetails()));
            }
            case "LastCollectedTime": {
                return Optional.ofNullable(clazz.cast(this.lastCollectedTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "RecorderStatus": {
                return Optional.ofNullable(clazz.cast(this.recorderStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LastRecorderStatus, T> g) {
        return obj -> g.apply((LastRecorderStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobStatusDetails;
        private Instant lastCollectedTime;
        private Instant lastUpdatedTime;
        private String recorderStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LastRecorderStatus model) {
            this.jobStatusDetails(model.jobStatusDetails);
            this.lastCollectedTime(model.lastCollectedTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.recorderStatus(model.recorderStatus);
        }

        public final String getJobStatusDetails() {
            return this.jobStatusDetails;
        }

        public final void setJobStatusDetails(String jobStatusDetails) {
            this.jobStatusDetails = jobStatusDetails;
        }

        @Override
        public final Builder jobStatusDetails(String jobStatusDetails) {
            this.jobStatusDetails = jobStatusDetails;
            return this;
        }

        public final Instant getLastCollectedTime() {
            return this.lastCollectedTime;
        }

        public final void setLastCollectedTime(Instant lastCollectedTime) {
            this.lastCollectedTime = lastCollectedTime;
        }

        @Override
        public final Builder lastCollectedTime(Instant lastCollectedTime) {
            this.lastCollectedTime = lastCollectedTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getRecorderStatus() {
            return this.recorderStatus;
        }

        public final void setRecorderStatus(String recorderStatus) {
            this.recorderStatus = recorderStatus;
        }

        @Override
        public final Builder recorderStatus(String recorderStatus) {
            this.recorderStatus = recorderStatus;
            return this;
        }

        @Override
        public final Builder recorderStatus(RecorderStatus recorderStatus) {
            this.recorderStatus(recorderStatus == null ? null : recorderStatus.toString());
            return this;
        }

        public LastRecorderStatus build() {
            return new LastRecorderStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LastRecorderStatus> {
        public Builder jobStatusDetails(String var1);

        public Builder lastCollectedTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder recorderStatus(String var1);

        public Builder recorderStatus(RecorderStatus var1);
    }
}

