/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChannelProtocol {
    WSS("WSS"),
    HTTPS("HTTPS"),
    WEBRTC("WEBRTC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChannelProtocol> VALUE_MAP;
    private final String value;

    private ChannelProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChannelProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChannelProtocol> knownValues() {
        EnumSet<ChannelProtocol> knownValues = EnumSet.allOf(ChannelProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChannelProtocol.class, ChannelProtocol::toString);
    }
}

