/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.ChannelType;
import software.amazon.awssdk.services.kinesisvideo.model.SingleMasterConfiguration;
import software.amazon.awssdk.services.kinesisvideo.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelInfo> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(ChannelInfo.getter(ChannelInfo::channelName)).setter(ChannelInfo.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelARN").getter(ChannelInfo.getter(ChannelInfo::channelARN)).setter(ChannelInfo.setter(Builder::channelARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelARN").build()}).build();
    private static final SdkField<String> CHANNEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelType").getter(ChannelInfo.getter(ChannelInfo::channelTypeAsString)).setter(ChannelInfo.setter(Builder::channelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelType").build()}).build();
    private static final SdkField<String> CHANNEL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelStatus").getter(ChannelInfo.getter(ChannelInfo::channelStatusAsString)).setter(ChannelInfo.setter(Builder::channelStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ChannelInfo.getter(ChannelInfo::creationTime)).setter(ChannelInfo.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<SingleMasterConfiguration> SINGLE_MASTER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SingleMasterConfiguration").getter(ChannelInfo.getter(ChannelInfo::singleMasterConfiguration)).setter(ChannelInfo.setter(Builder::singleMasterConfiguration)).constructor(SingleMasterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleMasterConfiguration").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(ChannelInfo.getter(ChannelInfo::version)).setter(ChannelInfo.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD, CHANNEL_ARN_FIELD, CHANNEL_TYPE_FIELD, CHANNEL_STATUS_FIELD, CREATION_TIME_FIELD, SINGLE_MASTER_CONFIGURATION_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ChannelName", CHANNEL_NAME_FIELD);
            this.put("ChannelARN", CHANNEL_ARN_FIELD);
            this.put("ChannelType", CHANNEL_TYPE_FIELD);
            this.put("ChannelStatus", CHANNEL_STATUS_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("SingleMasterConfiguration", SINGLE_MASTER_CONFIGURATION_FIELD);
            this.put("Version", VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String channelName;
    private final String channelARN;
    private final String channelType;
    private final String channelStatus;
    private final Instant creationTime;
    private final SingleMasterConfiguration singleMasterConfiguration;
    private final String version;

    private ChannelInfo(BuilderImpl builder) {
        this.channelName = builder.channelName;
        this.channelARN = builder.channelARN;
        this.channelType = builder.channelType;
        this.channelStatus = builder.channelStatus;
        this.creationTime = builder.creationTime;
        this.singleMasterConfiguration = builder.singleMasterConfiguration;
        this.version = builder.version;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String channelARN() {
        return this.channelARN;
    }

    public final ChannelType channelType() {
        return ChannelType.fromValue(this.channelType);
    }

    public final String channelTypeAsString() {
        return this.channelType;
    }

    public final Status channelStatus() {
        return Status.fromValue(this.channelStatus);
    }

    public final String channelStatusAsString() {
        return this.channelStatus;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final SingleMasterConfiguration singleMasterConfiguration() {
        return this.singleMasterConfiguration;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleMasterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelInfo)) {
            return false;
        }
        ChannelInfo other = (ChannelInfo)obj;
        return Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.channelARN(), other.channelARN()) && Objects.equals(this.channelTypeAsString(), other.channelTypeAsString()) && Objects.equals(this.channelStatusAsString(), other.channelStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.singleMasterConfiguration(), other.singleMasterConfiguration()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelInfo").add("ChannelName", (Object)this.channelName()).add("ChannelARN", (Object)this.channelARN()).add("ChannelType", (Object)this.channelTypeAsString()).add("ChannelStatus", (Object)this.channelStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("SingleMasterConfiguration", (Object)this.singleMasterConfiguration()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "ChannelARN": {
                return Optional.ofNullable(clazz.cast(this.channelARN()));
            }
            case "ChannelType": {
                return Optional.ofNullable(clazz.cast(this.channelTypeAsString()));
            }
            case "ChannelStatus": {
                return Optional.ofNullable(clazz.cast(this.channelStatusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "SingleMasterConfiguration": {
                return Optional.ofNullable(clazz.cast(this.singleMasterConfiguration()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ChannelInfo, T> g) {
        return obj -> g.apply((ChannelInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelName;
        private String channelARN;
        private String channelType;
        private String channelStatus;
        private Instant creationTime;
        private SingleMasterConfiguration singleMasterConfiguration;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelInfo model) {
            this.channelName(model.channelName);
            this.channelARN(model.channelARN);
            this.channelType(model.channelType);
            this.channelStatus(model.channelStatus);
            this.creationTime(model.creationTime);
            this.singleMasterConfiguration(model.singleMasterConfiguration);
            this.version(model.version);
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelARN() {
            return this.channelARN;
        }

        public final void setChannelARN(String channelARN) {
            this.channelARN = channelARN;
        }

        @Override
        public final Builder channelARN(String channelARN) {
            this.channelARN = channelARN;
            return this;
        }

        public final String getChannelType() {
            return this.channelType;
        }

        public final void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        @Override
        public final Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        @Override
        public final Builder channelType(ChannelType channelType) {
            this.channelType(channelType == null ? null : channelType.toString());
            return this;
        }

        public final String getChannelStatus() {
            return this.channelStatus;
        }

        public final void setChannelStatus(String channelStatus) {
            this.channelStatus = channelStatus;
        }

        @Override
        public final Builder channelStatus(String channelStatus) {
            this.channelStatus = channelStatus;
            return this;
        }

        @Override
        public final Builder channelStatus(Status channelStatus) {
            this.channelStatus(channelStatus == null ? null : channelStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final SingleMasterConfiguration.Builder getSingleMasterConfiguration() {
            return this.singleMasterConfiguration != null ? this.singleMasterConfiguration.toBuilder() : null;
        }

        public final void setSingleMasterConfiguration(SingleMasterConfiguration.BuilderImpl singleMasterConfiguration) {
            this.singleMasterConfiguration = singleMasterConfiguration != null ? singleMasterConfiguration.build() : null;
        }

        @Override
        public final Builder singleMasterConfiguration(SingleMasterConfiguration singleMasterConfiguration) {
            this.singleMasterConfiguration = singleMasterConfiguration;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public ChannelInfo build() {
            return new ChannelInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelInfo> {
        public Builder channelName(String var1);

        public Builder channelARN(String var1);

        public Builder channelType(String var1);

        public Builder channelType(ChannelType var1);

        public Builder channelStatus(String var1);

        public Builder channelStatus(Status var1);

        public Builder creationTime(Instant var1);

        public Builder singleMasterConfiguration(SingleMasterConfiguration var1);

        default public Builder singleMasterConfiguration(Consumer<SingleMasterConfiguration.Builder> singleMasterConfiguration) {
            return this.singleMasterConfiguration((SingleMasterConfiguration)((SingleMasterConfiguration.Builder)SingleMasterConfiguration.builder().applyMutation(singleMasterConfiguration)).build());
        }

        public Builder version(String var1);
    }
}

