/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityDisplayData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityDisplayData> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(EntityDisplayData.getter(EntityDisplayData::userName)).setter(EntityDisplayData.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(EntityDisplayData.getter(EntityDisplayData::groupName)).setter(EntityDisplayData.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<String> IDENTIFIED_USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentifiedUserName").getter(EntityDisplayData.getter(EntityDisplayData::identifiedUserName)).setter(EntityDisplayData.setter(Builder::identifiedUserName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifiedUserName").build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirstName").getter(EntityDisplayData.getter(EntityDisplayData::firstName)).setter(EntityDisplayData.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastName").getter(EntityDisplayData.getter(EntityDisplayData::lastName)).setter(EntityDisplayData.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, GROUP_NAME_FIELD, IDENTIFIED_USER_NAME_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UserName", USER_NAME_FIELD);
            this.put("GroupName", GROUP_NAME_FIELD);
            this.put("IdentifiedUserName", IDENTIFIED_USER_NAME_FIELD);
            this.put("FirstName", FIRST_NAME_FIELD);
            this.put("LastName", LAST_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String userName;
    private final String groupName;
    private final String identifiedUserName;
    private final String firstName;
    private final String lastName;

    private EntityDisplayData(BuilderImpl builder) {
        this.userName = builder.userName;
        this.groupName = builder.groupName;
        this.identifiedUserName = builder.identifiedUserName;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
    }

    public final String userName() {
        return this.userName;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String identifiedUserName() {
        return this.identifiedUserName;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifiedUserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityDisplayData)) {
            return false;
        }
        EntityDisplayData other = (EntityDisplayData)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.identifiedUserName(), other.identifiedUserName()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName());
    }

    public final String toString() {
        return ToString.builder((String)"EntityDisplayData").add("UserName", (Object)(this.userName() == null ? null : "*** Sensitive Data Redacted ***")).add("GroupName", (Object)(this.groupName() == null ? null : "*** Sensitive Data Redacted ***")).add("IdentifiedUserName", (Object)(this.identifiedUserName() == null ? null : "*** Sensitive Data Redacted ***")).add("FirstName", (Object)(this.firstName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastName", (Object)(this.lastName() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "IdentifiedUserName": {
                return Optional.ofNullable(clazz.cast(this.identifiedUserName()));
            }
            case "FirstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "LastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EntityDisplayData, T> g) {
        return obj -> g.apply((EntityDisplayData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String groupName;
        private String identifiedUserName;
        private String firstName;
        private String lastName;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityDisplayData model) {
            this.userName(model.userName);
            this.groupName(model.groupName);
            this.identifiedUserName(model.identifiedUserName);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getIdentifiedUserName() {
            return this.identifiedUserName;
        }

        public final void setIdentifiedUserName(String identifiedUserName) {
            this.identifiedUserName = identifiedUserName;
        }

        @Override
        public final Builder identifiedUserName(String identifiedUserName) {
            this.identifiedUserName = identifiedUserName;
            return this;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public EntityDisplayData build() {
            return new EntityDisplayData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityDisplayData> {
        public Builder userName(String var1);

        public Builder groupName(String var1);

        public Builder identifiedUserName(String var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);
    }
}

