/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.VpcConnectionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcConnection> {
    private static final SdkField<String> VPC_CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcConnectionArn").getter(VpcConnection.getter(VpcConnection::vpcConnectionArn)).setter(VpcConnection.setter(Builder::vpcConnectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionArn").build()}).build();
    private static final SdkField<String> TARGET_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetClusterArn").getter(VpcConnection.getter(VpcConnection::targetClusterArn)).setter(VpcConnection.setter(Builder::targetClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetClusterArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(VpcConnection.getter(VpcConnection::creationTime)).setter(VpcConnection.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Authentication").getter(VpcConnection.getter(VpcConnection::authentication)).setter(VpcConnection.setter(Builder::authentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authentication").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(VpcConnection.getter(VpcConnection::vpcId)).setter(VpcConnection.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(VpcConnection.getter(VpcConnection::stateAsString)).setter(VpcConnection.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTION_ARN_FIELD, TARGET_CLUSTER_ARN_FIELD, CREATION_TIME_FIELD, AUTHENTICATION_FIELD, VPC_ID_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("vpcConnectionArn", VPC_CONNECTION_ARN_FIELD);
            this.put("targetClusterArn", TARGET_CLUSTER_ARN_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("authentication", AUTHENTICATION_FIELD);
            this.put("vpcId", VPC_ID_FIELD);
            this.put("state", STATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String vpcConnectionArn;
    private final String targetClusterArn;
    private final Instant creationTime;
    private final String authentication;
    private final String vpcId;
    private final String state;

    private VpcConnection(BuilderImpl builder) {
        this.vpcConnectionArn = builder.vpcConnectionArn;
        this.targetClusterArn = builder.targetClusterArn;
        this.creationTime = builder.creationTime;
        this.authentication = builder.authentication;
        this.vpcId = builder.vpcId;
        this.state = builder.state;
    }

    public final String vpcConnectionArn() {
        return this.vpcConnectionArn;
    }

    public final String targetClusterArn() {
        return this.targetClusterArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String authentication() {
        return this.authentication;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final VpcConnectionState state() {
        return VpcConnectionState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.authentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConnection)) {
            return false;
        }
        VpcConnection other = (VpcConnection)obj;
        return Objects.equals(this.vpcConnectionArn(), other.vpcConnectionArn()) && Objects.equals(this.targetClusterArn(), other.targetClusterArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.authentication(), other.authentication()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"VpcConnection").add("VpcConnectionArn", (Object)this.vpcConnectionArn()).add("TargetClusterArn", (Object)this.targetClusterArn()).add("CreationTime", (Object)this.creationTime()).add("Authentication", (Object)this.authentication()).add("VpcId", (Object)this.vpcId()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionArn()));
            }
            case "TargetClusterArn": {
                return Optional.ofNullable(clazz.cast(this.targetClusterArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Authentication": {
                return Optional.ofNullable(clazz.cast(this.authentication()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VpcConnection, T> g) {
        return obj -> g.apply((VpcConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcConnectionArn;
        private String targetClusterArn;
        private Instant creationTime;
        private String authentication;
        private String vpcId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConnection model) {
            this.vpcConnectionArn(model.vpcConnectionArn);
            this.targetClusterArn(model.targetClusterArn);
            this.creationTime(model.creationTime);
            this.authentication(model.authentication);
            this.vpcId(model.vpcId);
            this.state(model.state);
        }

        public final String getVpcConnectionArn() {
            return this.vpcConnectionArn;
        }

        public final void setVpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
        }

        @Override
        public final Builder vpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        public final String getTargetClusterArn() {
            return this.targetClusterArn;
        }

        public final void setTargetClusterArn(String targetClusterArn) {
            this.targetClusterArn = targetClusterArn;
        }

        @Override
        public final Builder targetClusterArn(String targetClusterArn) {
            this.targetClusterArn = targetClusterArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getAuthentication() {
            return this.authentication;
        }

        public final void setAuthentication(String authentication) {
            this.authentication = authentication;
        }

        @Override
        public final Builder authentication(String authentication) {
            this.authentication = authentication;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcConnectionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public VpcConnection build() {
            return new VpcConnection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcConnection> {
        public Builder vpcConnectionArn(String var1);

        public Builder targetClusterArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder authentication(String var1);

        public Builder vpcId(String var1);

        public Builder state(String var1);

        public Builder state(VpcConnectionState var1);
    }
}

