/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StreamState {
    LIVE("LIVE"),
    OFFLINE("OFFLINE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StreamState> VALUE_MAP;
    private final String value;

    private StreamState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StreamState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StreamState> knownValues() {
        EnumSet<StreamState> knownValues = EnumSet.allOf(StreamState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StreamState.class, StreamState::toString);
    }
}

