/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivs.model.MultitrackMaximumResolution;
import software.amazon.awssdk.services.ivs.model.MultitrackPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultitrackInputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultitrackInputConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(MultitrackInputConfiguration.getter(MultitrackInputConfiguration::enabled)).setter(MultitrackInputConfiguration.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<String> MAXIMUM_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("maximumResolution").getter(MultitrackInputConfiguration.getter(MultitrackInputConfiguration::maximumResolutionAsString)).setter(MultitrackInputConfiguration.setter(Builder::maximumResolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumResolution").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policy").getter(MultitrackInputConfiguration.getter(MultitrackInputConfiguration::policyAsString)).setter(MultitrackInputConfiguration.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, MAXIMUM_RESOLUTION_FIELD, POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("enabled", ENABLED_FIELD);
            this.put("maximumResolution", MAXIMUM_RESOLUTION_FIELD);
            this.put("policy", POLICY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String maximumResolution;
    private final String policy;

    private MultitrackInputConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.maximumResolution = builder.maximumResolution;
        this.policy = builder.policy;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final MultitrackMaximumResolution maximumResolution() {
        return MultitrackMaximumResolution.fromValue(this.maximumResolution);
    }

    public final String maximumResolutionAsString() {
        return this.maximumResolution;
    }

    public final MultitrackPolicy policy() {
        return MultitrackPolicy.fromValue(this.policy);
    }

    public final String policyAsString() {
        return this.policy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultitrackInputConfiguration)) {
            return false;
        }
        MultitrackInputConfiguration other = (MultitrackInputConfiguration)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.maximumResolutionAsString(), other.maximumResolutionAsString()) && Objects.equals(this.policyAsString(), other.policyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MultitrackInputConfiguration").add("Enabled", (Object)this.enabled()).add("MaximumResolution", (Object)this.maximumResolutionAsString()).add("Policy", (Object)this.policyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "maximumResolution": {
                return Optional.ofNullable(clazz.cast(this.maximumResolutionAsString()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MultitrackInputConfiguration, T> g) {
        return obj -> g.apply((MultitrackInputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String maximumResolution;
        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(MultitrackInputConfiguration model) {
            this.enabled(model.enabled);
            this.maximumResolution(model.maximumResolution);
            this.policy(model.policy);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getMaximumResolution() {
            return this.maximumResolution;
        }

        public final void setMaximumResolution(String maximumResolution) {
            this.maximumResolution = maximumResolution;
        }

        @Override
        public final Builder maximumResolution(String maximumResolution) {
            this.maximumResolution = maximumResolution;
            return this;
        }

        @Override
        public final Builder maximumResolution(MultitrackMaximumResolution maximumResolution) {
            this.maximumResolution(maximumResolution == null ? null : maximumResolution.toString());
            return this;
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public final Builder policy(MultitrackPolicy policy) {
            this.policy(policy == null ? null : policy.toString());
            return this;
        }

        public MultitrackInputConfiguration build() {
            return new MultitrackInputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultitrackInputConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder maximumResolution(String var1);

        public Builder maximumResolution(MultitrackMaximumResolution var1);

        public Builder policy(String var1);

        public Builder policy(MultitrackPolicy var1);
    }
}

