/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessClient;
import software.amazon.awssdk.services.iotwireless.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDeviceProfilesResponse;

public class ListDeviceProfilesIterable
implements SdkIterable<ListDeviceProfilesResponse> {
    private final IotWirelessClient client;
    private final ListDeviceProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeviceProfilesIterable(IotWirelessClient client, ListDeviceProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDeviceProfilesResponseFetcher();
    }

    public Iterator<ListDeviceProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDeviceProfilesResponseFetcher
    implements SyncPageFetcher<ListDeviceProfilesResponse> {
        private ListDeviceProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListDeviceProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeviceProfilesResponse nextPage(ListDeviceProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListDeviceProfilesIterable.this.client.listDeviceProfiles(ListDeviceProfilesIterable.this.firstRequest);
            }
            return ListDeviceProfilesIterable.this.client.listDeviceProfiles((ListDeviceProfilesRequest)((Object)ListDeviceProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

