/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OnboardStatus {
    INITIALIZED("INITIALIZED"),
    PENDING("PENDING"),
    ONBOARDED("ONBOARDED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OnboardStatus> VALUE_MAP;
    private final String value;

    private OnboardStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OnboardStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OnboardStatus> knownValues() {
        EnumSet<OnboardStatus> knownValues = EnumSet.allOf(OnboardStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OnboardStatus.class, OnboardStatus::toString);
    }
}

