/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceStatistics;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceStatisticsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWirelessDevicesResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, ListWirelessDevicesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWirelessDevicesResponse.getter(ListWirelessDevicesResponse::nextToken)).setter(ListWirelessDevicesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<WirelessDeviceStatistics>> WIRELESS_DEVICE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WirelessDeviceList").getter(ListWirelessDevicesResponse.getter(ListWirelessDevicesResponse::wirelessDeviceList)).setter(ListWirelessDevicesResponse.setter(Builder::wirelessDeviceList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDeviceList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WirelessDeviceStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WIRELESS_DEVICE_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("WirelessDeviceList", WIRELESS_DEVICE_LIST_FIELD);
        }
    });
    private final String nextToken;
    private final List<WirelessDeviceStatistics> wirelessDeviceList;

    private ListWirelessDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.wirelessDeviceList = builder.wirelessDeviceList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWirelessDeviceList() {
        return this.wirelessDeviceList != null && !(this.wirelessDeviceList instanceof SdkAutoConstructList);
    }

    public final List<WirelessDeviceStatistics> wirelessDeviceList() {
        return this.wirelessDeviceList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWirelessDeviceList() ? this.wirelessDeviceList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWirelessDevicesResponse)) {
            return false;
        }
        ListWirelessDevicesResponse other = (ListWirelessDevicesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWirelessDeviceList() == other.hasWirelessDeviceList() && Objects.equals(this.wirelessDeviceList(), other.wirelessDeviceList());
    }

    public final String toString() {
        return ToString.builder((String)"ListWirelessDevicesResponse").add("NextToken", (Object)this.nextToken()).add("WirelessDeviceList", this.hasWirelessDeviceList() ? this.wirelessDeviceList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "WirelessDeviceList": {
                return Optional.ofNullable(clazz.cast(this.wirelessDeviceList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListWirelessDevicesResponse, T> g) {
        return obj -> g.apply((ListWirelessDevicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<WirelessDeviceStatistics> wirelessDeviceList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWirelessDevicesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.wirelessDeviceList(model.wirelessDeviceList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WirelessDeviceStatistics.Builder> getWirelessDeviceList() {
            List<WirelessDeviceStatistics.Builder> result = WirelessDeviceStatisticsListCopier.copyToBuilder(this.wirelessDeviceList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWirelessDeviceList(Collection<WirelessDeviceStatistics.BuilderImpl> wirelessDeviceList) {
            this.wirelessDeviceList = WirelessDeviceStatisticsListCopier.copyFromBuilder(wirelessDeviceList);
        }

        @Override
        public final Builder wirelessDeviceList(Collection<WirelessDeviceStatistics> wirelessDeviceList) {
            this.wirelessDeviceList = WirelessDeviceStatisticsListCopier.copy(wirelessDeviceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDeviceList(WirelessDeviceStatistics ... wirelessDeviceList) {
            this.wirelessDeviceList(Arrays.asList(wirelessDeviceList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDeviceList(Consumer<WirelessDeviceStatistics.Builder> ... wirelessDeviceList) {
            this.wirelessDeviceList(Stream.of(wirelessDeviceList).map(c -> (WirelessDeviceStatistics)((WirelessDeviceStatistics.Builder)WirelessDeviceStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWirelessDevicesResponse build() {
            return new ListWirelessDevicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWirelessDevicesResponse> {
        public Builder nextToken(String var1);

        public Builder wirelessDeviceList(Collection<WirelessDeviceStatistics> var1);

        public Builder wirelessDeviceList(WirelessDeviceStatistics ... var1);

        public Builder wirelessDeviceList(Consumer<WirelessDeviceStatistics.Builder> ... var1);
    }
}

