/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.GlueConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DestinationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DestinationConfiguration> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucket").getter(S3DestinationConfiguration.getter(S3DestinationConfiguration::bucket)).setter(S3DestinationConfiguration.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(S3DestinationConfiguration.getter(S3DestinationConfiguration::key)).setter(S3DestinationConfiguration.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<GlueConfiguration> GLUE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("glueConfiguration").getter(S3DestinationConfiguration.getter(S3DestinationConfiguration::glueConfiguration)).setter(S3DestinationConfiguration.setter(Builder::glueConfiguration)).constructor(GlueConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueConfiguration").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(S3DestinationConfiguration.getter(S3DestinationConfiguration::roleArn)).setter(S3DestinationConfiguration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, KEY_FIELD, GLUE_CONFIGURATION_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("bucket", BUCKET_FIELD);
            this.put("key", KEY_FIELD);
            this.put("glueConfiguration", GLUE_CONFIGURATION_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final String key;
    private final GlueConfiguration glueConfiguration;
    private final String roleArn;

    private S3DestinationConfiguration(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.glueConfiguration = builder.glueConfiguration;
        this.roleArn = builder.roleArn;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String key() {
        return this.key;
    }

    public final GlueConfiguration glueConfiguration() {
        return this.glueConfiguration;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationConfiguration)) {
            return false;
        }
        S3DestinationConfiguration other = (S3DestinationConfiguration)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.glueConfiguration(), other.glueConfiguration()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"S3DestinationConfiguration").add("Bucket", (Object)this.bucket()).add("Key", (Object)this.key()).add("GlueConfiguration", (Object)this.glueConfiguration()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "glueConfiguration": {
                return Optional.ofNullable(clazz.cast(this.glueConfiguration()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3DestinationConfiguration, T> g) {
        return obj -> g.apply((S3DestinationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String key;
        private GlueConfiguration glueConfiguration;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DestinationConfiguration model) {
            this.bucket(model.bucket);
            this.key(model.key);
            this.glueConfiguration(model.glueConfiguration);
            this.roleArn(model.roleArn);
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final GlueConfiguration.Builder getGlueConfiguration() {
            return this.glueConfiguration != null ? this.glueConfiguration.toBuilder() : null;
        }

        public final void setGlueConfiguration(GlueConfiguration.BuilderImpl glueConfiguration) {
            this.glueConfiguration = glueConfiguration != null ? glueConfiguration.build() : null;
        }

        @Override
        public final Builder glueConfiguration(GlueConfiguration glueConfiguration) {
            this.glueConfiguration = glueConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public S3DestinationConfiguration build() {
            return new S3DestinationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DestinationConfiguration> {
        public Builder bucket(String var1);

        public Builder key(String var1);

        public Builder glueConfiguration(GlueConfiguration var1);

        default public Builder glueConfiguration(Consumer<GlueConfiguration.Builder> glueConfiguration) {
            return this.glueConfiguration((GlueConfiguration)((GlueConfiguration.Builder)GlueConfiguration.builder().applyMutation(glueConfiguration)).build());
        }

        public Builder roleArn(String var1);
    }
}

