/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.ContainerDatasetAction;
import software.amazon.awssdk.services.iotanalytics.model.SqlQueryDatasetAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetAction> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionName").getter(DatasetAction.getter(DatasetAction::actionName)).setter(DatasetAction.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()}).build();
    private static final SdkField<SqlQueryDatasetAction> QUERY_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("queryAction").getter(DatasetAction.getter(DatasetAction::queryAction)).setter(DatasetAction.setter(Builder::queryAction)).constructor(SqlQueryDatasetAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryAction").build()}).build();
    private static final SdkField<ContainerDatasetAction> CONTAINER_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerAction").getter(DatasetAction.getter(DatasetAction::containerAction)).setter(DatasetAction.setter(Builder::containerAction)).constructor(ContainerDatasetAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD, QUERY_ACTION_FIELD, CONTAINER_ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("actionName", ACTION_NAME_FIELD);
            this.put("queryAction", QUERY_ACTION_FIELD);
            this.put("containerAction", CONTAINER_ACTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String actionName;
    private final SqlQueryDatasetAction queryAction;
    private final ContainerDatasetAction containerAction;

    private DatasetAction(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.queryAction = builder.queryAction;
        this.containerAction = builder.containerAction;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final SqlQueryDatasetAction queryAction() {
        return this.queryAction;
    }

    public final ContainerDatasetAction containerAction() {
        return this.containerAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerAction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetAction)) {
            return false;
        }
        DatasetAction other = (DatasetAction)obj;
        return Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.queryAction(), other.queryAction()) && Objects.equals(this.containerAction(), other.containerAction());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetAction").add("ActionName", (Object)this.actionName()).add("QueryAction", (Object)this.queryAction()).add("ContainerAction", (Object)this.containerAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "queryAction": {
                return Optional.ofNullable(clazz.cast(this.queryAction()));
            }
            case "containerAction": {
                return Optional.ofNullable(clazz.cast(this.containerAction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatasetAction, T> g) {
        return obj -> g.apply((DatasetAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionName;
        private SqlQueryDatasetAction queryAction;
        private ContainerDatasetAction containerAction;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetAction model) {
            this.actionName(model.actionName);
            this.queryAction(model.queryAction);
            this.containerAction(model.containerAction);
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final SqlQueryDatasetAction.Builder getQueryAction() {
            return this.queryAction != null ? this.queryAction.toBuilder() : null;
        }

        public final void setQueryAction(SqlQueryDatasetAction.BuilderImpl queryAction) {
            this.queryAction = queryAction != null ? queryAction.build() : null;
        }

        @Override
        public final Builder queryAction(SqlQueryDatasetAction queryAction) {
            this.queryAction = queryAction;
            return this;
        }

        public final ContainerDatasetAction.Builder getContainerAction() {
            return this.containerAction != null ? this.containerAction.toBuilder() : null;
        }

        public final void setContainerAction(ContainerDatasetAction.BuilderImpl containerAction) {
            this.containerAction = containerAction != null ? containerAction.build() : null;
        }

        @Override
        public final Builder containerAction(ContainerDatasetAction containerAction) {
            this.containerAction = containerAction;
            return this;
        }

        public DatasetAction build() {
            return new DatasetAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetAction> {
        public Builder actionName(String var1);

        public Builder queryAction(SqlQueryDatasetAction var1);

        default public Builder queryAction(Consumer<SqlQueryDatasetAction.Builder> queryAction) {
            return this.queryAction((SqlQueryDatasetAction)((SqlQueryDatasetAction.Builder)SqlQueryDatasetAction.builder().applyMutation(queryAction)).build());
        }

        public Builder containerAction(ContainerDatasetAction var1);

        default public Builder containerAction(Consumer<ContainerDatasetAction.Builder> containerAction) {
            return this.containerAction((ContainerDatasetAction)((ContainerDatasetAction.Builder)ContainerDatasetAction.builder().applyMutation(containerAction)).build());
        }
    }
}

