/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceType {
    DATA("DATA"),
    CREDENTIAL_PROVIDER("CREDENTIAL_PROVIDER"),
    JOBS("JOBS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceType> VALUE_MAP;
    private final String value;

    private ServiceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceType> knownValues() {
        EnumSet<ServiceType> knownValues = EnumSet.allOf(ServiceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceType.class, ServiceType::toString);
    }
}

