/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.MetricDatum;
import software.amazon.awssdk.services.iot.model.MetricDatumListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMetricValuesResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListMetricValuesResponse> {
    private static final SdkField<List<MetricDatum>> METRIC_DATUM_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricDatumList").getter(ListMetricValuesResponse.getter(ListMetricValuesResponse::metricDatumList)).setter(ListMetricValuesResponse.setter(Builder::metricDatumList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDatumList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDatum::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMetricValuesResponse.getter(ListMetricValuesResponse::nextToken)).setter(ListMetricValuesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DATUM_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("metricDatumList", METRIC_DATUM_LIST_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<MetricDatum> metricDatumList;
    private final String nextToken;

    private ListMetricValuesResponse(BuilderImpl builder) {
        super(builder);
        this.metricDatumList = builder.metricDatumList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMetricDatumList() {
        return this.metricDatumList != null && !(this.metricDatumList instanceof SdkAutoConstructList);
    }

    public final List<MetricDatum> metricDatumList() {
        return this.metricDatumList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDatumList() ? this.metricDatumList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricValuesResponse)) {
            return false;
        }
        ListMetricValuesResponse other = (ListMetricValuesResponse)((Object)obj);
        return this.hasMetricDatumList() == other.hasMetricDatumList() && Objects.equals(this.metricDatumList(), other.metricDatumList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMetricValuesResponse").add("MetricDatumList", this.hasMetricDatumList() ? this.metricDatumList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricDatumList": {
                return Optional.ofNullable(clazz.cast(this.metricDatumList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListMetricValuesResponse, T> g) {
        return obj -> g.apply((ListMetricValuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<MetricDatum> metricDatumList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricValuesResponse model) {
            super(model);
            this.metricDatumList(model.metricDatumList);
            this.nextToken(model.nextToken);
        }

        public final List<MetricDatum.Builder> getMetricDatumList() {
            List<MetricDatum.Builder> result = MetricDatumListCopier.copyToBuilder(this.metricDatumList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDatumList(Collection<MetricDatum.BuilderImpl> metricDatumList) {
            this.metricDatumList = MetricDatumListCopier.copyFromBuilder(metricDatumList);
        }

        @Override
        public final Builder metricDatumList(Collection<MetricDatum> metricDatumList) {
            this.metricDatumList = MetricDatumListCopier.copy(metricDatumList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDatumList(MetricDatum ... metricDatumList) {
            this.metricDatumList(Arrays.asList(metricDatumList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDatumList(Consumer<MetricDatum.Builder> ... metricDatumList) {
            this.metricDatumList(Stream.of(metricDatumList).map(c -> (MetricDatum)((MetricDatum.Builder)MetricDatum.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMetricValuesResponse build() {
            return new ListMetricValuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMetricValuesResponse> {
        public Builder metricDatumList(Collection<MetricDatum> var1);

        public Builder metricDatumList(MetricDatum ... var1);

        public Builder metricDatumList(Consumer<MetricDatum.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

