/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.FreeTrialInfo;
import software.amazon.awssdk.services.inspector2.model.FreeTrialInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FreeTrialAccountInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FreeTrialAccountInfo> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(FreeTrialAccountInfo.getter(FreeTrialAccountInfo::accountId)).setter(FreeTrialAccountInfo.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<List<FreeTrialInfo>> FREE_TRIAL_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("freeTrialInfo").getter(FreeTrialAccountInfo.getter(FreeTrialAccountInfo::freeTrialInfo)).setter(FreeTrialAccountInfo.setter(Builder::freeTrialInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeTrialInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FreeTrialInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, FREE_TRIAL_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accountId", ACCOUNT_ID_FIELD);
            this.put("freeTrialInfo", FREE_TRIAL_INFO_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final List<FreeTrialInfo> freeTrialInfo;

    private FreeTrialAccountInfo(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.freeTrialInfo = builder.freeTrialInfo;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final boolean hasFreeTrialInfo() {
        return this.freeTrialInfo != null && !(this.freeTrialInfo instanceof SdkAutoConstructList);
    }

    public final List<FreeTrialInfo> freeTrialInfo() {
        return this.freeTrialInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFreeTrialInfo() ? this.freeTrialInfo() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FreeTrialAccountInfo)) {
            return false;
        }
        FreeTrialAccountInfo other = (FreeTrialAccountInfo)obj;
        return Objects.equals(this.accountId(), other.accountId()) && this.hasFreeTrialInfo() == other.hasFreeTrialInfo() && Objects.equals(this.freeTrialInfo(), other.freeTrialInfo());
    }

    public final String toString() {
        return ToString.builder((String)"FreeTrialAccountInfo").add("AccountId", (Object)this.accountId()).add("FreeTrialInfo", this.hasFreeTrialInfo() ? this.freeTrialInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "freeTrialInfo": {
                return Optional.ofNullable(clazz.cast(this.freeTrialInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FreeTrialAccountInfo, T> g) {
        return obj -> g.apply((FreeTrialAccountInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private List<FreeTrialInfo> freeTrialInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FreeTrialAccountInfo model) {
            this.accountId(model.accountId);
            this.freeTrialInfo(model.freeTrialInfo);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final List<FreeTrialInfo.Builder> getFreeTrialInfo() {
            List<FreeTrialInfo.Builder> result = FreeTrialInfoListCopier.copyToBuilder(this.freeTrialInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFreeTrialInfo(Collection<FreeTrialInfo.BuilderImpl> freeTrialInfo) {
            this.freeTrialInfo = FreeTrialInfoListCopier.copyFromBuilder(freeTrialInfo);
        }

        @Override
        public final Builder freeTrialInfo(Collection<FreeTrialInfo> freeTrialInfo) {
            this.freeTrialInfo = FreeTrialInfoListCopier.copy(freeTrialInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder freeTrialInfo(FreeTrialInfo ... freeTrialInfo) {
            this.freeTrialInfo(Arrays.asList(freeTrialInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder freeTrialInfo(Consumer<FreeTrialInfo.Builder> ... freeTrialInfo) {
            this.freeTrialInfo(Stream.of(freeTrialInfo).map(c -> (FreeTrialInfo)((FreeTrialInfo.Builder)FreeTrialInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FreeTrialAccountInfo build() {
            return new FreeTrialAccountInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FreeTrialAccountInfo> {
        public Builder accountId(String var1);

        public Builder freeTrialInfo(Collection<FreeTrialInfo> var1);

        public Builder freeTrialInfo(FreeTrialInfo ... var1);

        public Builder freeTrialInfo(Consumer<FreeTrialInfo.Builder> ... var1);
    }
}

