/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.ResourceState;
import software.amazon.awssdk.services.inspector2.model.State;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountState> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(AccountState.getter(AccountState::accountId)).setter(AccountState.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<ResourceState> RESOURCE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceState").getter(AccountState.getter(AccountState::resourceState)).setter(AccountState.setter(Builder::resourceState)).constructor(ResourceState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceState").build()}).build();
    private static final SdkField<State> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(AccountState.getter(AccountState::state)).setter(AccountState.setter(Builder::state)).constructor(State::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, RESOURCE_STATE_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accountId", ACCOUNT_ID_FIELD);
            this.put("resourceState", RESOURCE_STATE_FIELD);
            this.put("state", STATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final ResourceState resourceState;
    private final State state;

    private AccountState(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.resourceState = builder.resourceState;
        this.state = builder.state;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final ResourceState resourceState() {
        return this.resourceState;
    }

    public final State state() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceState());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountState)) {
            return false;
        }
        AccountState other = (AccountState)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.resourceState(), other.resourceState()) && Objects.equals(this.state(), other.state());
    }

    public final String toString() {
        return ToString.builder((String)"AccountState").add("AccountId", (Object)this.accountId()).add("ResourceState", (Object)this.resourceState()).add("State", (Object)this.state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "resourceState": {
                return Optional.ofNullable(clazz.cast(this.resourceState()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccountState, T> g) {
        return obj -> g.apply((AccountState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private ResourceState resourceState;
        private State state;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountState model) {
            this.accountId(model.accountId);
            this.resourceState(model.resourceState);
            this.state(model.state);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final ResourceState.Builder getResourceState() {
            return this.resourceState != null ? this.resourceState.toBuilder() : null;
        }

        public final void setResourceState(ResourceState.BuilderImpl resourceState) {
            this.resourceState = resourceState != null ? resourceState.build() : null;
        }

        @Override
        public final Builder resourceState(ResourceState resourceState) {
            this.resourceState = resourceState;
            return this;
        }

        public final State.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(State.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(State state) {
            this.state = state;
            return this;
        }

        public AccountState build() {
            return new AccountState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountState> {
        public Builder accountId(String var1);

        public Builder resourceState(ResourceState var1);

        default public Builder resourceState(Consumer<ResourceState.Builder> resourceState) {
            return this.resourceState((ResourceState)((ResourceState.Builder)ResourceState.builder().applyMutation(resourceState)).build());
        }

        public Builder state(State var1);

        default public Builder state(Consumer<State.Builder> state) {
            return this.state((State)((State.Builder)State.builder().applyMutation(state)).build());
        }
    }
}

