/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorClient;
import software.amazon.awssdk.services.inspector.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest;
import software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse;

public class ListEventSubscriptionsIterable
implements SdkIterable<ListEventSubscriptionsResponse> {
    private final InspectorClient client;
    private final ListEventSubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventSubscriptionsIterable(InspectorClient client, ListEventSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEventSubscriptionsResponseFetcher();
    }

    public Iterator<ListEventSubscriptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListEventSubscriptionsResponseFetcher
    implements SyncPageFetcher<ListEventSubscriptionsResponse> {
        private ListEventSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventSubscriptionsResponse nextPage(ListEventSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListEventSubscriptionsIterable.this.client.listEventSubscriptions(ListEventSubscriptionsIterable.this.firstRequest);
            }
            return ListEventSubscriptionsIterable.this.client.listEventSubscriptions((ListEventSubscriptionsRequest)((Object)ListEventSubscriptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

