/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorClient;
import software.amazon.awssdk.services.inspector.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse;

public class ListAssessmentTargetsIterable
implements SdkIterable<ListAssessmentTargetsResponse> {
    private final InspectorClient client;
    private final ListAssessmentTargetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssessmentTargetsIterable(InspectorClient client, ListAssessmentTargetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssessmentTargetsResponseFetcher();
    }

    public Iterator<ListAssessmentTargetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAssessmentTargetsResponseFetcher
    implements SyncPageFetcher<ListAssessmentTargetsResponse> {
        private ListAssessmentTargetsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssessmentTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssessmentTargetsResponse nextPage(ListAssessmentTargetsResponse previousPage) {
            if (previousPage == null) {
                return ListAssessmentTargetsIterable.this.client.listAssessmentTargets(ListAssessmentTargetsIterable.this.firstRequest);
            }
            return ListAssessmentTargetsIterable.this.client.listAssessmentTargets((ListAssessmentTargetsRequest)((Object)ListAssessmentTargetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

