/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.auth.scheme.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.inspector.auth.scheme.InspectorAuthSchemeParams;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultInspectorAuthSchemeParams
implements InspectorAuthSchemeParams {
    private final String operation;
    private final Region region;

    private DefaultInspectorAuthSchemeParams(Builder builder) {
        this.operation = (String)Validate.paramNotNull((Object)builder.operation, (String)"operation");
        this.region = builder.region;
    }

    public static InspectorAuthSchemeParams.Builder builder() {
        return new Builder();
    }

    @Override
    public String operation() {
        return this.operation;
    }

    @Override
    public Region region() {
        return this.region;
    }

    @Override
    public InspectorAuthSchemeParams.Builder toBuilder() {
        return new Builder(this);
    }

    private static final class Builder
    implements InspectorAuthSchemeParams.Builder {
        private String operation;
        private Region region;

        Builder() {
        }

        Builder(DefaultInspectorAuthSchemeParams params) {
            this.operation = params.operation;
            this.region = params.region;
        }

        @Override
        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public InspectorAuthSchemeParams build() {
            return new DefaultInspectorAuthSchemeParams(this);
        }
    }
}

