/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.grafana.model.GrafanaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteWorkspaceServiceAccountTokenRequest
extends GrafanaRequest
implements ToCopyableBuilder<Builder, DeleteWorkspaceServiceAccountTokenRequest> {
    private static final SdkField<String> SERVICE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceAccountId").getter(DeleteWorkspaceServiceAccountTokenRequest.getter(DeleteWorkspaceServiceAccountTokenRequest::serviceAccountId)).setter(DeleteWorkspaceServiceAccountTokenRequest.setter(Builder::serviceAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("serviceAccountId").build()}).build();
    private static final SdkField<String> TOKEN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenId").getter(DeleteWorkspaceServiceAccountTokenRequest.getter(DeleteWorkspaceServiceAccountTokenRequest::tokenId)).setter(DeleteWorkspaceServiceAccountTokenRequest.setter(Builder::tokenId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tokenId").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(DeleteWorkspaceServiceAccountTokenRequest.getter(DeleteWorkspaceServiceAccountTokenRequest::workspaceId)).setter(DeleteWorkspaceServiceAccountTokenRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCOUNT_ID_FIELD, TOKEN_ID_FIELD, WORKSPACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("serviceAccountId", SERVICE_ACCOUNT_ID_FIELD);
            this.put("tokenId", TOKEN_ID_FIELD);
            this.put("workspaceId", WORKSPACE_ID_FIELD);
        }
    });
    private final String serviceAccountId;
    private final String tokenId;
    private final String workspaceId;

    private DeleteWorkspaceServiceAccountTokenRequest(BuilderImpl builder) {
        super(builder);
        this.serviceAccountId = builder.serviceAccountId;
        this.tokenId = builder.tokenId;
        this.workspaceId = builder.workspaceId;
    }

    public final String serviceAccountId() {
        return this.serviceAccountId;
    }

    public final String tokenId() {
        return this.tokenId;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteWorkspaceServiceAccountTokenRequest)) {
            return false;
        }
        DeleteWorkspaceServiceAccountTokenRequest other = (DeleteWorkspaceServiceAccountTokenRequest)((Object)obj);
        return Objects.equals(this.serviceAccountId(), other.serviceAccountId()) && Objects.equals(this.tokenId(), other.tokenId()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteWorkspaceServiceAccountTokenRequest").add("ServiceAccountId", (Object)this.serviceAccountId()).add("TokenId", (Object)this.tokenId()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceAccountId": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountId()));
            }
            case "tokenId": {
                return Optional.ofNullable(clazz.cast(this.tokenId()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteWorkspaceServiceAccountTokenRequest, T> g) {
        return obj -> g.apply((DeleteWorkspaceServiceAccountTokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaRequest.BuilderImpl
    implements Builder {
        private String serviceAccountId;
        private String tokenId;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteWorkspaceServiceAccountTokenRequest model) {
            super(model);
            this.serviceAccountId(model.serviceAccountId);
            this.tokenId(model.tokenId);
            this.workspaceId(model.workspaceId);
        }

        public final String getServiceAccountId() {
            return this.serviceAccountId;
        }

        public final void setServiceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
        }

        @Override
        public final Builder serviceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
            return this;
        }

        public final String getTokenId() {
            return this.tokenId;
        }

        public final void setTokenId(String tokenId) {
            this.tokenId = tokenId;
        }

        @Override
        public final Builder tokenId(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteWorkspaceServiceAccountTokenRequest build() {
            return new DeleteWorkspaceServiceAccountTokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GrafanaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteWorkspaceServiceAccountTokenRequest> {
        public Builder serviceAccountId(String var1);

        public Builder tokenId(String var1);

        public Builder workspaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

