/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.GameServerGroupAction;
import software.amazon.awssdk.services.gamelift.model.GameServerGroupActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuspendGameServerGroupRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, SuspendGameServerGroupRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerGroupName").getter(SuspendGameServerGroupRequest.getter(SuspendGameServerGroupRequest::gameServerGroupName)).setter(SuspendGameServerGroupRequest.setter(Builder::gameServerGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build()}).build();
    private static final SdkField<List<String>> SUSPEND_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuspendActions").getter(SuspendGameServerGroupRequest.getter(SuspendGameServerGroupRequest::suspendActionsAsStrings)).setter(SuspendGameServerGroupRequest.setter(Builder::suspendActionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuspendActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD, SUSPEND_ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GameServerGroupName", GAME_SERVER_GROUP_NAME_FIELD);
            this.put("SuspendActions", SUSPEND_ACTIONS_FIELD);
        }
    });
    private final String gameServerGroupName;
    private final List<String> suspendActions;

    private SuspendGameServerGroupRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.suspendActions = builder.suspendActions;
    }

    public final String gameServerGroupName() {
        return this.gameServerGroupName;
    }

    public final List<GameServerGroupAction> suspendActions() {
        return GameServerGroupActionsCopier.copyStringToEnum(this.suspendActions);
    }

    public final boolean hasSuspendActions() {
        return this.suspendActions != null && !(this.suspendActions instanceof SdkAutoConstructList);
    }

    public final List<String> suspendActionsAsStrings() {
        return this.suspendActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuspendActions() ? this.suspendActionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendGameServerGroupRequest)) {
            return false;
        }
        SuspendGameServerGroupRequest other = (SuspendGameServerGroupRequest)((Object)obj);
        return Objects.equals(this.gameServerGroupName(), other.gameServerGroupName()) && this.hasSuspendActions() == other.hasSuspendActions() && Objects.equals(this.suspendActionsAsStrings(), other.suspendActionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"SuspendGameServerGroupRequest").add("GameServerGroupName", (Object)this.gameServerGroupName()).add("SuspendActions", this.hasSuspendActions() ? this.suspendActionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameServerGroupName": {
                return Optional.ofNullable(clazz.cast(this.gameServerGroupName()));
            }
            case "SuspendActions": {
                return Optional.ofNullable(clazz.cast(this.suspendActionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SuspendGameServerGroupRequest, T> g) {
        return obj -> g.apply((SuspendGameServerGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameServerGroupName;
        private List<String> suspendActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SuspendGameServerGroupRequest model) {
            super(model);
            this.gameServerGroupName(model.gameServerGroupName);
            this.suspendActionsWithStrings(model.suspendActions);
        }

        public final String getGameServerGroupName() {
            return this.gameServerGroupName;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final Collection<String> getSuspendActions() {
            if (this.suspendActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.suspendActions;
        }

        public final void setSuspendActions(Collection<String> suspendActions) {
            this.suspendActions = GameServerGroupActionsCopier.copy(suspendActions);
        }

        @Override
        public final Builder suspendActionsWithStrings(Collection<String> suspendActions) {
            this.suspendActions = GameServerGroupActionsCopier.copy(suspendActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suspendActionsWithStrings(String ... suspendActions) {
            this.suspendActionsWithStrings(Arrays.asList(suspendActions));
            return this;
        }

        @Override
        public final Builder suspendActions(Collection<GameServerGroupAction> suspendActions) {
            this.suspendActions = GameServerGroupActionsCopier.copyEnumToString(suspendActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suspendActions(GameServerGroupAction ... suspendActions) {
            this.suspendActions(Arrays.asList(suspendActions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SuspendGameServerGroupRequest build() {
            return new SuspendGameServerGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SuspendGameServerGroupRequest> {
        public Builder gameServerGroupName(String var1);

        public Builder suspendActionsWithStrings(Collection<String> var1);

        public Builder suspendActionsWithStrings(String ... var1);

        public Builder suspendActions(Collection<GameServerGroupAction> var1);

        public Builder suspendActions(GameServerGroupAction ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

