/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.BuildStatus;
import software.amazon.awssdk.services.gamelift.model.OperatingSystem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Build
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Build> {
    private static final SdkField<String> BUILD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuildId").getter(Build.getter(Build::buildId)).setter(Build.setter(Builder::buildId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildId").build()}).build();
    private static final SdkField<String> BUILD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuildArn").getter(Build.getter(Build::buildArn)).setter(Build.setter(Builder::buildArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Build.getter(Build::name)).setter(Build.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(Build.getter(Build::version)).setter(Build.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Build.getter(Build::statusAsString)).setter(Build.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Long> SIZE_ON_DISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SizeOnDisk").getter(Build.getter(Build::sizeOnDisk)).setter(Build.setter(Builder::sizeOnDisk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeOnDisk").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(Build.getter(Build::operatingSystemAsString)).setter(Build.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Build.getter(Build::creationTime)).setter(Build.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> SERVER_SDK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerSdkVersion").getter(Build.getter(Build::serverSdkVersion)).setter(Build.setter(Builder::serverSdkVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSdkVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILD_ID_FIELD, BUILD_ARN_FIELD, NAME_FIELD, VERSION_FIELD, STATUS_FIELD, SIZE_ON_DISK_FIELD, OPERATING_SYSTEM_FIELD, CREATION_TIME_FIELD, SERVER_SDK_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BuildId", BUILD_ID_FIELD);
            this.put("BuildArn", BUILD_ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Version", VERSION_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("SizeOnDisk", SIZE_ON_DISK_FIELD);
            this.put("OperatingSystem", OPERATING_SYSTEM_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("ServerSdkVersion", SERVER_SDK_VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String buildId;
    private final String buildArn;
    private final String name;
    private final String version;
    private final String status;
    private final Long sizeOnDisk;
    private final String operatingSystem;
    private final Instant creationTime;
    private final String serverSdkVersion;

    private Build(BuilderImpl builder) {
        this.buildId = builder.buildId;
        this.buildArn = builder.buildArn;
        this.name = builder.name;
        this.version = builder.version;
        this.status = builder.status;
        this.sizeOnDisk = builder.sizeOnDisk;
        this.operatingSystem = builder.operatingSystem;
        this.creationTime = builder.creationTime;
        this.serverSdkVersion = builder.serverSdkVersion;
    }

    public final String buildId() {
        return this.buildId;
    }

    public final String buildArn() {
        return this.buildArn;
    }

    public final String name() {
        return this.name;
    }

    public final String version() {
        return this.version;
    }

    public final BuildStatus status() {
        return BuildStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Long sizeOnDisk() {
        return this.sizeOnDisk;
    }

    public final OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public final String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String serverSdkVersion() {
        return this.serverSdkVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.buildId());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeOnDisk());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSdkVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Build)) {
            return false;
        }
        Build other = (Build)obj;
        return Objects.equals(this.buildId(), other.buildId()) && Objects.equals(this.buildArn(), other.buildArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sizeOnDisk(), other.sizeOnDisk()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.serverSdkVersion(), other.serverSdkVersion());
    }

    public final String toString() {
        return ToString.builder((String)"Build").add("BuildId", (Object)this.buildId()).add("BuildArn", (Object)this.buildArn()).add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("Status", (Object)this.statusAsString()).add("SizeOnDisk", (Object)this.sizeOnDisk()).add("OperatingSystem", (Object)this.operatingSystemAsString()).add("CreationTime", (Object)this.creationTime()).add("ServerSdkVersion", (Object)this.serverSdkVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BuildId": {
                return Optional.ofNullable(clazz.cast(this.buildId()));
            }
            case "BuildArn": {
                return Optional.ofNullable(clazz.cast(this.buildArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SizeOnDisk": {
                return Optional.ofNullable(clazz.cast(this.sizeOnDisk()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ServerSdkVersion": {
                return Optional.ofNullable(clazz.cast(this.serverSdkVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Build, T> g) {
        return obj -> g.apply((Build)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String buildId;
        private String buildArn;
        private String name;
        private String version;
        private String status;
        private Long sizeOnDisk;
        private String operatingSystem;
        private Instant creationTime;
        private String serverSdkVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Build model) {
            this.buildId(model.buildId);
            this.buildArn(model.buildArn);
            this.name(model.name);
            this.version(model.version);
            this.status(model.status);
            this.sizeOnDisk(model.sizeOnDisk);
            this.operatingSystem(model.operatingSystem);
            this.creationTime(model.creationTime);
            this.serverSdkVersion(model.serverSdkVersion);
        }

        public final String getBuildId() {
            return this.buildId;
        }

        public final void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        @Override
        public final Builder buildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public final String getBuildArn() {
            return this.buildArn;
        }

        public final void setBuildArn(String buildArn) {
            this.buildArn = buildArn;
        }

        @Override
        public final Builder buildArn(String buildArn) {
            this.buildArn = buildArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BuildStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Long getSizeOnDisk() {
            return this.sizeOnDisk;
        }

        public final void setSizeOnDisk(Long sizeOnDisk) {
            this.sizeOnDisk = sizeOnDisk;
        }

        @Override
        public final Builder sizeOnDisk(Long sizeOnDisk) {
            this.sizeOnDisk = sizeOnDisk;
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getServerSdkVersion() {
            return this.serverSdkVersion;
        }

        public final void setServerSdkVersion(String serverSdkVersion) {
            this.serverSdkVersion = serverSdkVersion;
        }

        @Override
        public final Builder serverSdkVersion(String serverSdkVersion) {
            this.serverSdkVersion = serverSdkVersion;
            return this;
        }

        public Build build() {
            return new Build(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Build> {
        public Builder buildId(String var1);

        public Builder buildArn(String var1);

        public Builder name(String var1);

        public Builder version(String var1);

        public Builder status(String var1);

        public Builder status(BuildStatus var1);

        public Builder sizeOnDisk(Long var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder creationTime(Instant var1);

        public Builder serverSdkVersion(String var1);
    }
}

