/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.LustreNoSquashNidsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LustreRootSquashConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LustreRootSquashConfiguration> {
    private static final SdkField<String> ROOT_SQUASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootSquash").getter(LustreRootSquashConfiguration.getter(LustreRootSquashConfiguration::rootSquash)).setter(LustreRootSquashConfiguration.setter(Builder::rootSquash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootSquash").build()}).build();
    private static final SdkField<List<String>> NO_SQUASH_NIDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NoSquashNids").getter(LustreRootSquashConfiguration.getter(LustreRootSquashConfiguration::noSquashNids)).setter(LustreRootSquashConfiguration.setter(Builder::noSquashNids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoSquashNids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOT_SQUASH_FIELD, NO_SQUASH_NIDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RootSquash", ROOT_SQUASH_FIELD);
            this.put("NoSquashNids", NO_SQUASH_NIDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String rootSquash;
    private final List<String> noSquashNids;

    private LustreRootSquashConfiguration(BuilderImpl builder) {
        this.rootSquash = builder.rootSquash;
        this.noSquashNids = builder.noSquashNids;
    }

    public final String rootSquash() {
        return this.rootSquash;
    }

    public final boolean hasNoSquashNids() {
        return this.noSquashNids != null && !(this.noSquashNids instanceof SdkAutoConstructList);
    }

    public final List<String> noSquashNids() {
        return this.noSquashNids;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rootSquash());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNoSquashNids() ? this.noSquashNids() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LustreRootSquashConfiguration)) {
            return false;
        }
        LustreRootSquashConfiguration other = (LustreRootSquashConfiguration)obj;
        return Objects.equals(this.rootSquash(), other.rootSquash()) && this.hasNoSquashNids() == other.hasNoSquashNids() && Objects.equals(this.noSquashNids(), other.noSquashNids());
    }

    public final String toString() {
        return ToString.builder((String)"LustreRootSquashConfiguration").add("RootSquash", (Object)this.rootSquash()).add("NoSquashNids", this.hasNoSquashNids() ? this.noSquashNids() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RootSquash": {
                return Optional.ofNullable(clazz.cast(this.rootSquash()));
            }
            case "NoSquashNids": {
                return Optional.ofNullable(clazz.cast(this.noSquashNids()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LustreRootSquashConfiguration, T> g) {
        return obj -> g.apply((LustreRootSquashConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rootSquash;
        private List<String> noSquashNids = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LustreRootSquashConfiguration model) {
            this.rootSquash(model.rootSquash);
            this.noSquashNids(model.noSquashNids);
        }

        public final String getRootSquash() {
            return this.rootSquash;
        }

        public final void setRootSquash(String rootSquash) {
            this.rootSquash = rootSquash;
        }

        @Override
        public final Builder rootSquash(String rootSquash) {
            this.rootSquash = rootSquash;
            return this;
        }

        public final Collection<String> getNoSquashNids() {
            if (this.noSquashNids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.noSquashNids;
        }

        public final void setNoSquashNids(Collection<String> noSquashNids) {
            this.noSquashNids = LustreNoSquashNidsCopier.copy(noSquashNids);
        }

        @Override
        public final Builder noSquashNids(Collection<String> noSquashNids) {
            this.noSquashNids = LustreNoSquashNidsCopier.copy(noSquashNids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noSquashNids(String ... noSquashNids) {
            this.noSquashNids(Arrays.asList(noSquashNids));
            return this;
        }

        public LustreRootSquashConfiguration build() {
            return new LustreRootSquashConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LustreRootSquashConfiguration> {
        public Builder rootSquash(String var1);

        public Builder noSquashNids(Collection<String> var1);

        public Builder noSquashNids(String ... var1);
    }
}

