/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.ModelEndpointStatus;
import software.amazon.awssdk.services.frauddetector.model.ModelInputConfiguration;
import software.amazon.awssdk.services.frauddetector.model.ModelOutputConfiguration;
import software.amazon.awssdk.services.frauddetector.model.ModelSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalModel> {
    private static final SdkField<String> MODEL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelEndpoint").getter(ExternalModel.getter(ExternalModel::modelEndpoint)).setter(ExternalModel.setter(Builder::modelEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpoint").build()}).build();
    private static final SdkField<String> MODEL_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelSource").getter(ExternalModel.getter(ExternalModel::modelSourceAsString)).setter(ExternalModel.setter(Builder::modelSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSource").build()}).build();
    private static final SdkField<String> INVOKE_MODEL_ENDPOINT_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invokeModelEndpointRoleArn").getter(ExternalModel.getter(ExternalModel::invokeModelEndpointRoleArn)).setter(ExternalModel.setter(Builder::invokeModelEndpointRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invokeModelEndpointRoleArn").build()}).build();
    private static final SdkField<ModelInputConfiguration> INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputConfiguration").getter(ExternalModel.getter(ExternalModel::inputConfiguration)).setter(ExternalModel.setter(Builder::inputConfiguration)).constructor(ModelInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfiguration").build()}).build();
    private static final SdkField<ModelOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfiguration").getter(ExternalModel.getter(ExternalModel::outputConfiguration)).setter(ExternalModel.setter(Builder::outputConfiguration)).constructor(ModelOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build()}).build();
    private static final SdkField<String> MODEL_ENDPOINT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelEndpointStatus").getter(ExternalModel.getter(ExternalModel::modelEndpointStatusAsString)).setter(ExternalModel.setter(Builder::modelEndpointStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpointStatus").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedTime").getter(ExternalModel.getter(ExternalModel::lastUpdatedTime)).setter(ExternalModel.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdTime").getter(ExternalModel.getter(ExternalModel::createdTime)).setter(ExternalModel.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ExternalModel.getter(ExternalModel::arn)).setter(ExternalModel.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ENDPOINT_FIELD, MODEL_SOURCE_FIELD, INVOKE_MODEL_ENDPOINT_ROLE_ARN_FIELD, INPUT_CONFIGURATION_FIELD, OUTPUT_CONFIGURATION_FIELD, MODEL_ENDPOINT_STATUS_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("modelEndpoint", MODEL_ENDPOINT_FIELD);
            this.put("modelSource", MODEL_SOURCE_FIELD);
            this.put("invokeModelEndpointRoleArn", INVOKE_MODEL_ENDPOINT_ROLE_ARN_FIELD);
            this.put("inputConfiguration", INPUT_CONFIGURATION_FIELD);
            this.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
            this.put("modelEndpointStatus", MODEL_ENDPOINT_STATUS_FIELD);
            this.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
            this.put("createdTime", CREATED_TIME_FIELD);
            this.put("arn", ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String modelEndpoint;
    private final String modelSource;
    private final String invokeModelEndpointRoleArn;
    private final ModelInputConfiguration inputConfiguration;
    private final ModelOutputConfiguration outputConfiguration;
    private final String modelEndpointStatus;
    private final String lastUpdatedTime;
    private final String createdTime;
    private final String arn;

    private ExternalModel(BuilderImpl builder) {
        this.modelEndpoint = builder.modelEndpoint;
        this.modelSource = builder.modelSource;
        this.invokeModelEndpointRoleArn = builder.invokeModelEndpointRoleArn;
        this.inputConfiguration = builder.inputConfiguration;
        this.outputConfiguration = builder.outputConfiguration;
        this.modelEndpointStatus = builder.modelEndpointStatus;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
        this.arn = builder.arn;
    }

    public final String modelEndpoint() {
        return this.modelEndpoint;
    }

    public final ModelSource modelSource() {
        return ModelSource.fromValue(this.modelSource);
    }

    public final String modelSourceAsString() {
        return this.modelSource;
    }

    public final String invokeModelEndpointRoleArn() {
        return this.invokeModelEndpointRoleArn;
    }

    public final ModelInputConfiguration inputConfiguration() {
        return this.inputConfiguration;
    }

    public final ModelOutputConfiguration outputConfiguration() {
        return this.outputConfiguration;
    }

    public final ModelEndpointStatus modelEndpointStatus() {
        return ModelEndpointStatus.fromValue(this.modelEndpointStatus);
    }

    public final String modelEndpointStatusAsString() {
        return this.modelEndpointStatus;
    }

    public final String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String createdTime() {
        return this.createdTime;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.invokeModelEndpointRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelEndpointStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalModel)) {
            return false;
        }
        ExternalModel other = (ExternalModel)obj;
        return Objects.equals(this.modelEndpoint(), other.modelEndpoint()) && Objects.equals(this.modelSourceAsString(), other.modelSourceAsString()) && Objects.equals(this.invokeModelEndpointRoleArn(), other.invokeModelEndpointRoleArn()) && Objects.equals(this.inputConfiguration(), other.inputConfiguration()) && Objects.equals(this.outputConfiguration(), other.outputConfiguration()) && Objects.equals(this.modelEndpointStatusAsString(), other.modelEndpointStatusAsString()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"ExternalModel").add("ModelEndpoint", (Object)this.modelEndpoint()).add("ModelSource", (Object)this.modelSourceAsString()).add("InvokeModelEndpointRoleArn", (Object)this.invokeModelEndpointRoleArn()).add("InputConfiguration", (Object)this.inputConfiguration()).add("OutputConfiguration", (Object)this.outputConfiguration()).add("ModelEndpointStatus", (Object)this.modelEndpointStatusAsString()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("CreatedTime", (Object)this.createdTime()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelEndpoint": {
                return Optional.ofNullable(clazz.cast(this.modelEndpoint()));
            }
            case "modelSource": {
                return Optional.ofNullable(clazz.cast(this.modelSourceAsString()));
            }
            case "invokeModelEndpointRoleArn": {
                return Optional.ofNullable(clazz.cast(this.invokeModelEndpointRoleArn()));
            }
            case "inputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputConfiguration()));
            }
            case "outputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.outputConfiguration()));
            }
            case "modelEndpointStatus": {
                return Optional.ofNullable(clazz.cast(this.modelEndpointStatusAsString()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExternalModel, T> g) {
        return obj -> g.apply((ExternalModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelEndpoint;
        private String modelSource;
        private String invokeModelEndpointRoleArn;
        private ModelInputConfiguration inputConfiguration;
        private ModelOutputConfiguration outputConfiguration;
        private String modelEndpointStatus;
        private String lastUpdatedTime;
        private String createdTime;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalModel model) {
            this.modelEndpoint(model.modelEndpoint);
            this.modelSource(model.modelSource);
            this.invokeModelEndpointRoleArn(model.invokeModelEndpointRoleArn);
            this.inputConfiguration(model.inputConfiguration);
            this.outputConfiguration(model.outputConfiguration);
            this.modelEndpointStatus(model.modelEndpointStatus);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.createdTime(model.createdTime);
            this.arn(model.arn);
        }

        public final String getModelEndpoint() {
            return this.modelEndpoint;
        }

        public final void setModelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
        }

        @Override
        public final Builder modelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
            return this;
        }

        public final String getModelSource() {
            return this.modelSource;
        }

        public final void setModelSource(String modelSource) {
            this.modelSource = modelSource;
        }

        @Override
        public final Builder modelSource(String modelSource) {
            this.modelSource = modelSource;
            return this;
        }

        @Override
        public final Builder modelSource(ModelSource modelSource) {
            this.modelSource(modelSource == null ? null : modelSource.toString());
            return this;
        }

        public final String getInvokeModelEndpointRoleArn() {
            return this.invokeModelEndpointRoleArn;
        }

        public final void setInvokeModelEndpointRoleArn(String invokeModelEndpointRoleArn) {
            this.invokeModelEndpointRoleArn = invokeModelEndpointRoleArn;
        }

        @Override
        public final Builder invokeModelEndpointRoleArn(String invokeModelEndpointRoleArn) {
            this.invokeModelEndpointRoleArn = invokeModelEndpointRoleArn;
            return this;
        }

        public final ModelInputConfiguration.Builder getInputConfiguration() {
            return this.inputConfiguration != null ? this.inputConfiguration.toBuilder() : null;
        }

        public final void setInputConfiguration(ModelInputConfiguration.BuilderImpl inputConfiguration) {
            this.inputConfiguration = inputConfiguration != null ? inputConfiguration.build() : null;
        }

        @Override
        public final Builder inputConfiguration(ModelInputConfiguration inputConfiguration) {
            this.inputConfiguration = inputConfiguration;
            return this;
        }

        public final ModelOutputConfiguration.Builder getOutputConfiguration() {
            return this.outputConfiguration != null ? this.outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(ModelOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(ModelOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final String getModelEndpointStatus() {
            return this.modelEndpointStatus;
        }

        public final void setModelEndpointStatus(String modelEndpointStatus) {
            this.modelEndpointStatus = modelEndpointStatus;
        }

        @Override
        public final Builder modelEndpointStatus(String modelEndpointStatus) {
            this.modelEndpointStatus = modelEndpointStatus;
            return this;
        }

        @Override
        public final Builder modelEndpointStatus(ModelEndpointStatus modelEndpointStatus) {
            this.modelEndpointStatus(modelEndpointStatus == null ? null : modelEndpointStatus.toString());
            return this;
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public ExternalModel build() {
            return new ExternalModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalModel> {
        public Builder modelEndpoint(String var1);

        public Builder modelSource(String var1);

        public Builder modelSource(ModelSource var1);

        public Builder invokeModelEndpointRoleArn(String var1);

        public Builder inputConfiguration(ModelInputConfiguration var1);

        default public Builder inputConfiguration(Consumer<ModelInputConfiguration.Builder> inputConfiguration) {
            return this.inputConfiguration((ModelInputConfiguration)((ModelInputConfiguration.Builder)ModelInputConfiguration.builder().applyMutation(inputConfiguration)).build());
        }

        public Builder outputConfiguration(ModelOutputConfiguration var1);

        default public Builder outputConfiguration(Consumer<ModelOutputConfiguration.Builder> outputConfiguration) {
            return this.outputConfiguration((ModelOutputConfiguration)((ModelOutputConfiguration.Builder)ModelOutputConfiguration.builder().applyMutation(outputConfiguration)).build());
        }

        public Builder modelEndpointStatus(String var1);

        public Builder modelEndpointStatus(ModelEndpointStatus var1);

        public Builder lastUpdatedTime(String var1);

        public Builder createdTime(String var1);

        public Builder arn(String var1);
    }
}

