/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.ResourceArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebACLHasOutOfScopeResourcesViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebACLHasOutOfScopeResourcesViolation> {
    private static final SdkField<String> WEB_ACL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebACLArn").getter(WebACLHasOutOfScopeResourcesViolation.getter(WebACLHasOutOfScopeResourcesViolation::webACLArn)).setter(WebACLHasOutOfScopeResourcesViolation.setter(Builder::webACLArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLArn").build()}).build();
    private static final SdkField<List<String>> OUT_OF_SCOPE_RESOURCE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutOfScopeResourceList").getter(WebACLHasOutOfScopeResourcesViolation.getter(WebACLHasOutOfScopeResourcesViolation::outOfScopeResourceList)).setter(WebACLHasOutOfScopeResourcesViolation.setter(Builder::outOfScopeResourceList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutOfScopeResourceList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ARN_FIELD, OUT_OF_SCOPE_RESOURCE_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WebACLArn", WEB_ACL_ARN_FIELD);
            this.put("OutOfScopeResourceList", OUT_OF_SCOPE_RESOURCE_LIST_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String webACLArn;
    private final List<String> outOfScopeResourceList;

    private WebACLHasOutOfScopeResourcesViolation(BuilderImpl builder) {
        this.webACLArn = builder.webACLArn;
        this.outOfScopeResourceList = builder.outOfScopeResourceList;
    }

    public final String webACLArn() {
        return this.webACLArn;
    }

    public final boolean hasOutOfScopeResourceList() {
        return this.outOfScopeResourceList != null && !(this.outOfScopeResourceList instanceof SdkAutoConstructList);
    }

    public final List<String> outOfScopeResourceList() {
        return this.outOfScopeResourceList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutOfScopeResourceList() ? this.outOfScopeResourceList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebACLHasOutOfScopeResourcesViolation)) {
            return false;
        }
        WebACLHasOutOfScopeResourcesViolation other = (WebACLHasOutOfScopeResourcesViolation)obj;
        return Objects.equals(this.webACLArn(), other.webACLArn()) && this.hasOutOfScopeResourceList() == other.hasOutOfScopeResourceList() && Objects.equals(this.outOfScopeResourceList(), other.outOfScopeResourceList());
    }

    public final String toString() {
        return ToString.builder((String)"WebACLHasOutOfScopeResourcesViolation").add("WebACLArn", (Object)this.webACLArn()).add("OutOfScopeResourceList", this.hasOutOfScopeResourceList() ? this.outOfScopeResourceList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebACLArn": {
                return Optional.ofNullable(clazz.cast(this.webACLArn()));
            }
            case "OutOfScopeResourceList": {
                return Optional.ofNullable(clazz.cast(this.outOfScopeResourceList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WebACLHasOutOfScopeResourcesViolation, T> g) {
        return obj -> g.apply((WebACLHasOutOfScopeResourcesViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String webACLArn;
        private List<String> outOfScopeResourceList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WebACLHasOutOfScopeResourcesViolation model) {
            this.webACLArn(model.webACLArn);
            this.outOfScopeResourceList(model.outOfScopeResourceList);
        }

        public final String getWebACLArn() {
            return this.webACLArn;
        }

        public final void setWebACLArn(String webACLArn) {
            this.webACLArn = webACLArn;
        }

        @Override
        public final Builder webACLArn(String webACLArn) {
            this.webACLArn = webACLArn;
            return this;
        }

        public final Collection<String> getOutOfScopeResourceList() {
            if (this.outOfScopeResourceList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outOfScopeResourceList;
        }

        public final void setOutOfScopeResourceList(Collection<String> outOfScopeResourceList) {
            this.outOfScopeResourceList = ResourceArnListCopier.copy(outOfScopeResourceList);
        }

        @Override
        public final Builder outOfScopeResourceList(Collection<String> outOfScopeResourceList) {
            this.outOfScopeResourceList = ResourceArnListCopier.copy(outOfScopeResourceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outOfScopeResourceList(String ... outOfScopeResourceList) {
            this.outOfScopeResourceList(Arrays.asList(outOfScopeResourceList));
            return this;
        }

        public WebACLHasOutOfScopeResourcesViolation build() {
            return new WebACLHasOutOfScopeResourcesViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebACLHasOutOfScopeResourcesViolation> {
        public Builder webACLArn(String var1);

        public Builder outOfScopeResourceList(Collection<String> var1);

        public Builder outOfScopeResourceList(String ... var1);
    }
}

