/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.evidently.model.LaunchExecution;
import software.amazon.awssdk.services.evidently.model.LaunchGroup;
import software.amazon.awssdk.services.evidently.model.LaunchGroupListCopier;
import software.amazon.awssdk.services.evidently.model.LaunchStatus;
import software.amazon.awssdk.services.evidently.model.LaunchType;
import software.amazon.awssdk.services.evidently.model.MetricMonitor;
import software.amazon.awssdk.services.evidently.model.MetricMonitorListCopier;
import software.amazon.awssdk.services.evidently.model.ScheduledSplitsLaunchDefinition;
import software.amazon.awssdk.services.evidently.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Launch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Launch> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Launch.getter(Launch::arn)).setter(Launch.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(Launch.getter(Launch::createdTime)).setter(Launch.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Launch.getter(Launch::description)).setter(Launch.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<LaunchExecution> EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("execution").getter(Launch.getter(Launch::execution)).setter(Launch.setter(Builder::execution)).constructor(LaunchExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("execution").build()}).build();
    private static final SdkField<List<LaunchGroup>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groups").getter(Launch.getter(Launch::groups)).setter(Launch.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTime").getter(Launch.getter(Launch::lastUpdatedTime)).setter(Launch.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<List<MetricMonitor>> METRIC_MONITORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricMonitors").getter(Launch.getter(Launch::metricMonitors)).setter(Launch.setter(Builder::metricMonitors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricMonitors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricMonitor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Launch.getter(Launch::name)).setter(Launch.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("project").getter(Launch.getter(Launch::project)).setter(Launch.setter(Builder::project)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()}).build();
    private static final SdkField<String> RANDOMIZATION_SALT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("randomizationSalt").getter(Launch.getter(Launch::randomizationSalt)).setter(Launch.setter(Builder::randomizationSalt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("randomizationSalt").build()}).build();
    private static final SdkField<ScheduledSplitsLaunchDefinition> SCHEDULED_SPLITS_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scheduledSplitsDefinition").getter(Launch.getter(Launch::scheduledSplitsDefinition)).setter(Launch.setter(Builder::scheduledSplitsDefinition)).constructor(ScheduledSplitsLaunchDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledSplitsDefinition").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Launch.getter(Launch::statusAsString)).setter(Launch.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(Launch.getter(Launch::statusReason)).setter(Launch.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Launch.getter(Launch::tags)).setter(Launch.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Launch.getter(Launch::typeAsString)).setter(Launch.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_TIME_FIELD, DESCRIPTION_FIELD, EXECUTION_FIELD, GROUPS_FIELD, LAST_UPDATED_TIME_FIELD, METRIC_MONITORS_FIELD, NAME_FIELD, PROJECT_FIELD, RANDOMIZATION_SALT_FIELD, SCHEDULED_SPLITS_DEFINITION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, TAGS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("createdTime", CREATED_TIME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("execution", EXECUTION_FIELD);
            this.put("groups", GROUPS_FIELD);
            this.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
            this.put("metricMonitors", METRIC_MONITORS_FIELD);
            this.put("name", NAME_FIELD);
            this.put("project", PROJECT_FIELD);
            this.put("randomizationSalt", RANDOMIZATION_SALT_FIELD);
            this.put("scheduledSplitsDefinition", SCHEDULED_SPLITS_DEFINITION_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("statusReason", STATUS_REASON_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdTime;
    private final String description;
    private final LaunchExecution execution;
    private final List<LaunchGroup> groups;
    private final Instant lastUpdatedTime;
    private final List<MetricMonitor> metricMonitors;
    private final String name;
    private final String project;
    private final String randomizationSalt;
    private final ScheduledSplitsLaunchDefinition scheduledSplitsDefinition;
    private final String status;
    private final String statusReason;
    private final Map<String, String> tags;
    private final String type;

    private Launch(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.description = builder.description;
        this.execution = builder.execution;
        this.groups = builder.groups;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.metricMonitors = builder.metricMonitors;
        this.name = builder.name;
        this.project = builder.project;
        this.randomizationSalt = builder.randomizationSalt;
        this.scheduledSplitsDefinition = builder.scheduledSplitsDefinition;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String description() {
        return this.description;
    }

    public final LaunchExecution execution() {
        return this.execution;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<LaunchGroup> groups() {
        return this.groups;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final boolean hasMetricMonitors() {
        return this.metricMonitors != null && !(this.metricMonitors instanceof SdkAutoConstructList);
    }

    public final List<MetricMonitor> metricMonitors() {
        return this.metricMonitors;
    }

    public final String name() {
        return this.name;
    }

    public final String project() {
        return this.project;
    }

    public final String randomizationSalt() {
        return this.randomizationSalt;
    }

    public final ScheduledSplitsLaunchDefinition scheduledSplitsDefinition() {
        return this.scheduledSplitsDefinition;
    }

    public final LaunchStatus status() {
        return LaunchStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final LaunchType type() {
        return LaunchType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.execution());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricMonitors() ? this.metricMonitors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.randomizationSalt());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledSplitsDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Launch)) {
            return false;
        }
        Launch other = (Launch)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.execution(), other.execution()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && this.hasMetricMonitors() == other.hasMetricMonitors() && Objects.equals(this.metricMonitors(), other.metricMonitors()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.project(), other.project()) && Objects.equals(this.randomizationSalt(), other.randomizationSalt()) && Objects.equals(this.scheduledSplitsDefinition(), other.scheduledSplitsDefinition()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Launch").add("Arn", (Object)this.arn()).add("CreatedTime", (Object)this.createdTime()).add("Description", (Object)this.description()).add("Execution", (Object)this.execution()).add("Groups", this.hasGroups() ? this.groups() : null).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("MetricMonitors", this.hasMetricMonitors() ? this.metricMonitors() : null).add("Name", (Object)this.name()).add("Project", (Object)this.project()).add("RandomizationSalt", (Object)this.randomizationSalt()).add("ScheduledSplitsDefinition", (Object)this.scheduledSplitsDefinition()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "execution": {
                return Optional.ofNullable(clazz.cast(this.execution()));
            }
            case "groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "metricMonitors": {
                return Optional.ofNullable(clazz.cast(this.metricMonitors()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "randomizationSalt": {
                return Optional.ofNullable(clazz.cast(this.randomizationSalt()));
            }
            case "scheduledSplitsDefinition": {
                return Optional.ofNullable(clazz.cast(this.scheduledSplitsDefinition()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Launch, T> g) {
        return obj -> g.apply((Launch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdTime;
        private String description;
        private LaunchExecution execution;
        private List<LaunchGroup> groups = DefaultSdkAutoConstructList.getInstance();
        private Instant lastUpdatedTime;
        private List<MetricMonitor> metricMonitors = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String project;
        private String randomizationSalt;
        private ScheduledSplitsLaunchDefinition scheduledSplitsDefinition;
        private String status;
        private String statusReason;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Launch model) {
            this.arn(model.arn);
            this.createdTime(model.createdTime);
            this.description(model.description);
            this.execution(model.execution);
            this.groups(model.groups);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.metricMonitors(model.metricMonitors);
            this.name(model.name);
            this.project(model.project);
            this.randomizationSalt(model.randomizationSalt);
            this.scheduledSplitsDefinition(model.scheduledSplitsDefinition);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final LaunchExecution.Builder getExecution() {
            return this.execution != null ? this.execution.toBuilder() : null;
        }

        public final void setExecution(LaunchExecution.BuilderImpl execution) {
            this.execution = execution != null ? execution.build() : null;
        }

        @Override
        public final Builder execution(LaunchExecution execution) {
            this.execution = execution;
            return this;
        }

        public final List<LaunchGroup.Builder> getGroups() {
            List<LaunchGroup.Builder> result = LaunchGroupListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<LaunchGroup.BuilderImpl> groups) {
            this.groups = LaunchGroupListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<LaunchGroup> groups) {
            this.groups = LaunchGroupListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(LaunchGroup ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<LaunchGroup.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (LaunchGroup)((LaunchGroup.Builder)LaunchGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final List<MetricMonitor.Builder> getMetricMonitors() {
            List<MetricMonitor.Builder> result = MetricMonitorListCopier.copyToBuilder(this.metricMonitors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricMonitors(Collection<MetricMonitor.BuilderImpl> metricMonitors) {
            this.metricMonitors = MetricMonitorListCopier.copyFromBuilder(metricMonitors);
        }

        @Override
        public final Builder metricMonitors(Collection<MetricMonitor> metricMonitors) {
            this.metricMonitors = MetricMonitorListCopier.copy(metricMonitors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricMonitors(MetricMonitor ... metricMonitors) {
            this.metricMonitors(Arrays.asList(metricMonitors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricMonitors(Consumer<MetricMonitor.Builder> ... metricMonitors) {
            this.metricMonitors(Stream.of(metricMonitors).map(c -> (MetricMonitor)((MetricMonitor.Builder)MetricMonitor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProject() {
            return this.project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final String getRandomizationSalt() {
            return this.randomizationSalt;
        }

        public final void setRandomizationSalt(String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
        }

        @Override
        public final Builder randomizationSalt(String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
            return this;
        }

        public final ScheduledSplitsLaunchDefinition.Builder getScheduledSplitsDefinition() {
            return this.scheduledSplitsDefinition != null ? this.scheduledSplitsDefinition.toBuilder() : null;
        }

        public final void setScheduledSplitsDefinition(ScheduledSplitsLaunchDefinition.BuilderImpl scheduledSplitsDefinition) {
            this.scheduledSplitsDefinition = scheduledSplitsDefinition != null ? scheduledSplitsDefinition.build() : null;
        }

        @Override
        public final Builder scheduledSplitsDefinition(ScheduledSplitsLaunchDefinition scheduledSplitsDefinition) {
            this.scheduledSplitsDefinition = scheduledSplitsDefinition;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LaunchStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LaunchType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public Launch build() {
            return new Launch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Launch> {
        public Builder arn(String var1);

        public Builder createdTime(Instant var1);

        public Builder description(String var1);

        public Builder execution(LaunchExecution var1);

        default public Builder execution(Consumer<LaunchExecution.Builder> execution) {
            return this.execution((LaunchExecution)((LaunchExecution.Builder)LaunchExecution.builder().applyMutation(execution)).build());
        }

        public Builder groups(Collection<LaunchGroup> var1);

        public Builder groups(LaunchGroup ... var1);

        public Builder groups(Consumer<LaunchGroup.Builder> ... var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder metricMonitors(Collection<MetricMonitor> var1);

        public Builder metricMonitors(MetricMonitor ... var1);

        public Builder metricMonitors(Consumer<MetricMonitor.Builder> ... var1);

        public Builder name(String var1);

        public Builder project(String var1);

        public Builder randomizationSalt(String var1);

        public Builder scheduledSplitsDefinition(ScheduledSplitsLaunchDefinition var1);

        default public Builder scheduledSplitsDefinition(Consumer<ScheduledSplitsLaunchDefinition.Builder> scheduledSplitsDefinition) {
            return this.scheduledSplitsDefinition((ScheduledSplitsLaunchDefinition)((ScheduledSplitsLaunchDefinition.Builder)ScheduledSplitsLaunchDefinition.builder().applyMutation(scheduledSplitsDefinition)).build());
        }

        public Builder status(String var1);

        public Builder status(LaunchStatus var1);

        public Builder statusReason(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(LaunchType var1);
    }
}

