/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.services.ecr.model.RepositoryCreationTemplate;
import software.amazon.awssdk.services.ecr.model.RepositoryCreationTemplateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRepositoryCreationTemplatesResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, DescribeRepositoryCreationTemplatesResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(DescribeRepositoryCreationTemplatesResponse.getter(DescribeRepositoryCreationTemplatesResponse::registryId)).setter(DescribeRepositoryCreationTemplatesResponse.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<List<RepositoryCreationTemplate>> REPOSITORY_CREATION_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("repositoryCreationTemplates").getter(DescribeRepositoryCreationTemplatesResponse.getter(DescribeRepositoryCreationTemplatesResponse::repositoryCreationTemplates)).setter(DescribeRepositoryCreationTemplatesResponse.setter(Builder::repositoryCreationTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryCreationTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositoryCreationTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeRepositoryCreationTemplatesResponse.getter(DescribeRepositoryCreationTemplatesResponse::nextToken)).setter(DescribeRepositoryCreationTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_CREATION_TEMPLATES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("registryId", REGISTRY_ID_FIELD);
            this.put("repositoryCreationTemplates", REPOSITORY_CREATION_TEMPLATES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String registryId;
    private final List<RepositoryCreationTemplate> repositoryCreationTemplates;
    private final String nextToken;

    private DescribeRepositoryCreationTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryCreationTemplates = builder.repositoryCreationTemplates;
        this.nextToken = builder.nextToken;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final boolean hasRepositoryCreationTemplates() {
        return this.repositoryCreationTemplates != null && !(this.repositoryCreationTemplates instanceof SdkAutoConstructList);
    }

    public final List<RepositoryCreationTemplate> repositoryCreationTemplates() {
        return this.repositoryCreationTemplates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositoryCreationTemplates() ? this.repositoryCreationTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRepositoryCreationTemplatesResponse)) {
            return false;
        }
        DescribeRepositoryCreationTemplatesResponse other = (DescribeRepositoryCreationTemplatesResponse)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && this.hasRepositoryCreationTemplates() == other.hasRepositoryCreationTemplates() && Objects.equals(this.repositoryCreationTemplates(), other.repositoryCreationTemplates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRepositoryCreationTemplatesResponse").add("RegistryId", (Object)this.registryId()).add("RepositoryCreationTemplates", this.hasRepositoryCreationTemplates() ? this.repositoryCreationTemplates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryCreationTemplates": {
                return Optional.ofNullable(clazz.cast(this.repositoryCreationTemplates()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRepositoryCreationTemplatesResponse, T> g) {
        return obj -> g.apply((DescribeRepositoryCreationTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private String registryId;
        private List<RepositoryCreationTemplate> repositoryCreationTemplates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRepositoryCreationTemplatesResponse model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryCreationTemplates(model.repositoryCreationTemplates);
            this.nextToken(model.nextToken);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final List<RepositoryCreationTemplate.Builder> getRepositoryCreationTemplates() {
            List<RepositoryCreationTemplate.Builder> result = RepositoryCreationTemplateListCopier.copyToBuilder(this.repositoryCreationTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositoryCreationTemplates(Collection<RepositoryCreationTemplate.BuilderImpl> repositoryCreationTemplates) {
            this.repositoryCreationTemplates = RepositoryCreationTemplateListCopier.copyFromBuilder(repositoryCreationTemplates);
        }

        @Override
        public final Builder repositoryCreationTemplates(Collection<RepositoryCreationTemplate> repositoryCreationTemplates) {
            this.repositoryCreationTemplates = RepositoryCreationTemplateListCopier.copy(repositoryCreationTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryCreationTemplates(RepositoryCreationTemplate ... repositoryCreationTemplates) {
            this.repositoryCreationTemplates(Arrays.asList(repositoryCreationTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryCreationTemplates(Consumer<RepositoryCreationTemplate.Builder> ... repositoryCreationTemplates) {
            this.repositoryCreationTemplates(Stream.of(repositoryCreationTemplates).map(c -> (RepositoryCreationTemplate)((RepositoryCreationTemplate.Builder)RepositoryCreationTemplate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRepositoryCreationTemplatesResponse build() {
            return new DescribeRepositoryCreationTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRepositoryCreationTemplatesResponse> {
        public Builder registryId(String var1);

        public Builder repositoryCreationTemplates(Collection<RepositoryCreationTemplate> var1);

        public Builder repositoryCreationTemplates(RepositoryCreationTemplate ... var1);

        public Builder repositoryCreationTemplates(Consumer<RepositoryCreationTemplate.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

