/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.model.ShareMethod;
import software.amazon.awssdk.services.directory.model.ShareTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShareDirectoryRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, ShareDirectoryRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(ShareDirectoryRequest.getter(ShareDirectoryRequest::directoryId)).setter(ShareDirectoryRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> SHARE_NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareNotes").getter(ShareDirectoryRequest.getter(ShareDirectoryRequest::shareNotes)).setter(ShareDirectoryRequest.setter(Builder::shareNotes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareNotes").build()}).build();
    private static final SdkField<ShareTarget> SHARE_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShareTarget").getter(ShareDirectoryRequest.getter(ShareDirectoryRequest::shareTarget)).setter(ShareDirectoryRequest.setter(Builder::shareTarget)).constructor(ShareTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareTarget").build()}).build();
    private static final SdkField<String> SHARE_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareMethod").getter(ShareDirectoryRequest.getter(ShareDirectoryRequest::shareMethodAsString)).setter(ShareDirectoryRequest.setter(Builder::shareMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, SHARE_NOTES_FIELD, SHARE_TARGET_FIELD, SHARE_METHOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DirectoryId", DIRECTORY_ID_FIELD);
            this.put("ShareNotes", SHARE_NOTES_FIELD);
            this.put("ShareTarget", SHARE_TARGET_FIELD);
            this.put("ShareMethod", SHARE_METHOD_FIELD);
        }
    });
    private final String directoryId;
    private final String shareNotes;
    private final ShareTarget shareTarget;
    private final String shareMethod;

    private ShareDirectoryRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.shareNotes = builder.shareNotes;
        this.shareTarget = builder.shareTarget;
        this.shareMethod = builder.shareMethod;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String shareNotes() {
        return this.shareNotes;
    }

    public final ShareTarget shareTarget() {
        return this.shareTarget;
    }

    public final ShareMethod shareMethod() {
        return ShareMethod.fromValue(this.shareMethod);
    }

    public final String shareMethodAsString() {
        return this.shareMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareNotes());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareMethodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareDirectoryRequest)) {
            return false;
        }
        ShareDirectoryRequest other = (ShareDirectoryRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.shareNotes(), other.shareNotes()) && Objects.equals(this.shareTarget(), other.shareTarget()) && Objects.equals(this.shareMethodAsString(), other.shareMethodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ShareDirectoryRequest").add("DirectoryId", (Object)this.directoryId()).add("ShareNotes", (Object)(this.shareNotes() == null ? null : "*** Sensitive Data Redacted ***")).add("ShareTarget", (Object)this.shareTarget()).add("ShareMethod", (Object)this.shareMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "ShareNotes": {
                return Optional.ofNullable(clazz.cast(this.shareNotes()));
            }
            case "ShareTarget": {
                return Optional.ofNullable(clazz.cast(this.shareTarget()));
            }
            case "ShareMethod": {
                return Optional.ofNullable(clazz.cast(this.shareMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ShareDirectoryRequest, T> g) {
        return obj -> g.apply((ShareDirectoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private String shareNotes;
        private ShareTarget shareTarget;
        private String shareMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareDirectoryRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.shareNotes(model.shareNotes);
            this.shareTarget(model.shareTarget);
            this.shareMethod(model.shareMethod);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getShareNotes() {
            return this.shareNotes;
        }

        public final void setShareNotes(String shareNotes) {
            this.shareNotes = shareNotes;
        }

        @Override
        public final Builder shareNotes(String shareNotes) {
            this.shareNotes = shareNotes;
            return this;
        }

        public final ShareTarget.Builder getShareTarget() {
            return this.shareTarget != null ? this.shareTarget.toBuilder() : null;
        }

        public final void setShareTarget(ShareTarget.BuilderImpl shareTarget) {
            this.shareTarget = shareTarget != null ? shareTarget.build() : null;
        }

        @Override
        public final Builder shareTarget(ShareTarget shareTarget) {
            this.shareTarget = shareTarget;
            return this;
        }

        public final String getShareMethod() {
            return this.shareMethod;
        }

        public final void setShareMethod(String shareMethod) {
            this.shareMethod = shareMethod;
        }

        @Override
        public final Builder shareMethod(String shareMethod) {
            this.shareMethod = shareMethod;
            return this;
        }

        @Override
        public final Builder shareMethod(ShareMethod shareMethod) {
            this.shareMethod(shareMethod == null ? null : shareMethod.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ShareDirectoryRequest build() {
            return new ShareDirectoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ShareDirectoryRequest> {
        public Builder directoryId(String var1);

        public Builder shareNotes(String var1);

        public Builder shareTarget(ShareTarget var1);

        default public Builder shareTarget(Consumer<ShareTarget.Builder> shareTarget) {
            return this.shareTarget((ShareTarget)((ShareTarget.Builder)ShareTarget.builder().applyMutation(shareTarget)).build());
        }

        public Builder shareMethod(String var1);

        public Builder shareMethod(ShareMethod var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

