/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.TaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetTaskStatusRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, SetTaskStatusRequest> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(SetTaskStatusRequest.getter(SetTaskStatusRequest::taskId)).setter(SetTaskStatusRequest.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskStatus").getter(SetTaskStatusRequest.getter(SetTaskStatusRequest::taskStatusAsString)).setter(SetTaskStatusRequest.setter(Builder::taskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatus").build()}).build();
    private static final SdkField<String> ERROR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorId").getter(SetTaskStatusRequest.getter(SetTaskStatusRequest::errorId)).setter(SetTaskStatusRequest.setter(Builder::errorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorId").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(SetTaskStatusRequest.getter(SetTaskStatusRequest::errorMessage)).setter(SetTaskStatusRequest.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> ERROR_STACK_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorStackTrace").getter(SetTaskStatusRequest.getter(SetTaskStatusRequest::errorStackTrace)).setter(SetTaskStatusRequest.setter(Builder::errorStackTrace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorStackTrace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, TASK_STATUS_FIELD, ERROR_ID_FIELD, ERROR_MESSAGE_FIELD, ERROR_STACK_TRACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("taskId", TASK_ID_FIELD);
            this.put("taskStatus", TASK_STATUS_FIELD);
            this.put("errorId", ERROR_ID_FIELD);
            this.put("errorMessage", ERROR_MESSAGE_FIELD);
            this.put("errorStackTrace", ERROR_STACK_TRACE_FIELD);
        }
    });
    private final String taskId;
    private final String taskStatus;
    private final String errorId;
    private final String errorMessage;
    private final String errorStackTrace;

    private SetTaskStatusRequest(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.taskStatus = builder.taskStatus;
        this.errorId = builder.errorId;
        this.errorMessage = builder.errorMessage;
        this.errorStackTrace = builder.errorStackTrace;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final TaskStatus taskStatus() {
        return TaskStatus.fromValue(this.taskStatus);
    }

    public final String taskStatusAsString() {
        return this.taskStatus;
    }

    public final String errorId() {
        return this.errorId;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String errorStackTrace() {
        return this.errorStackTrace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorStackTrace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetTaskStatusRequest)) {
            return false;
        }
        SetTaskStatusRequest other = (SetTaskStatusRequest)((Object)obj);
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.taskStatusAsString(), other.taskStatusAsString()) && Objects.equals(this.errorId(), other.errorId()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorStackTrace(), other.errorStackTrace());
    }

    public final String toString() {
        return ToString.builder((String)"SetTaskStatusRequest").add("TaskId", (Object)this.taskId()).add("TaskStatus", (Object)this.taskStatusAsString()).add("ErrorId", (Object)this.errorId()).add("ErrorMessage", (Object)this.errorMessage()).add("ErrorStackTrace", (Object)this.errorStackTrace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "taskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
            case "errorId": {
                return Optional.ofNullable(clazz.cast(this.errorId()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "errorStackTrace": {
                return Optional.ofNullable(clazz.cast(this.errorStackTrace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SetTaskStatusRequest, T> g) {
        return obj -> g.apply((SetTaskStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private String taskId;
        private String taskStatus;
        private String errorId;
        private String errorMessage;
        private String errorStackTrace;

        private BuilderImpl() {
        }

        private BuilderImpl(SetTaskStatusRequest model) {
            super(model);
            this.taskId(model.taskId);
            this.taskStatus(model.taskStatus);
            this.errorId(model.errorId);
            this.errorMessage(model.errorMessage);
            this.errorStackTrace(model.errorStackTrace);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(TaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final String getErrorId() {
            return this.errorId;
        }

        public final void setErrorId(String errorId) {
            this.errorId = errorId;
        }

        @Override
        public final Builder errorId(String errorId) {
            this.errorId = errorId;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorStackTrace() {
            return this.errorStackTrace;
        }

        public final void setErrorStackTrace(String errorStackTrace) {
            this.errorStackTrace = errorStackTrace;
        }

        @Override
        public final Builder errorStackTrace(String errorStackTrace) {
            this.errorStackTrace = errorStackTrace;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetTaskStatusRequest build() {
            return new SetTaskStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetTaskStatusRequest> {
        public Builder taskId(String var1);

        public Builder taskStatus(String var1);

        public Builder taskStatus(TaskStatus var1);

        public Builder errorId(String var1);

        public Builder errorMessage(String var1);

        public Builder errorStackTrace(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

