/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LFPermission {
    DESCRIBE("DESCRIBE"),
    SELECT("SELECT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LFPermission> VALUE_MAP;
    private final String value;

    private LFPermission(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LFPermission fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LFPermission> knownValues() {
        EnumSet<LFPermission> knownValues = EnumSet.allOf(LFPermission.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LFPermission.class, LFPermission::toString);
    }
}

