/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListUserProficienciesRequest;
import software.amazon.awssdk.services.connect.model.ListUserProficienciesResponse;
import software.amazon.awssdk.services.connect.model.UserProficiency;

public class ListUserProficienciesPublisher
implements SdkPublisher<ListUserProficienciesResponse> {
    private final ConnectAsyncClient client;
    private final ListUserProficienciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUserProficienciesPublisher(ConnectAsyncClient client, ListUserProficienciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUserProficienciesPublisher(ConnectAsyncClient client, ListUserProficienciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUserProficienciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUserProficienciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UserProficiency> userProficiencyList() {
        Function<ListUserProficienciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.userProficiencyList() != null) {
                return response.userProficiencyList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUserProficienciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUserProficienciesResponseFetcher
    implements AsyncPageFetcher<ListUserProficienciesResponse> {
        private ListUserProficienciesResponseFetcher() {
        }

        public boolean hasNextPage(ListUserProficienciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUserProficienciesResponse> nextPage(ListUserProficienciesResponse previousPage) {
            if (previousPage == null) {
                return ListUserProficienciesPublisher.this.client.listUserProficiencies(ListUserProficienciesPublisher.this.firstRequest);
            }
            return ListUserProficienciesPublisher.this.client.listUserProficiencies((ListUserProficienciesRequest)((Object)ListUserProficienciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

