/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.AuthenticationProfileSummary;
import software.amazon.awssdk.services.connect.model.ListAuthenticationProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListAuthenticationProfilesResponse;

public class ListAuthenticationProfilesPublisher
implements SdkPublisher<ListAuthenticationProfilesResponse> {
    private final ConnectAsyncClient client;
    private final ListAuthenticationProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAuthenticationProfilesPublisher(ConnectAsyncClient client, ListAuthenticationProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAuthenticationProfilesPublisher(ConnectAsyncClient client, ListAuthenticationProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAuthenticationProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAuthenticationProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AuthenticationProfileSummary> authenticationProfileSummaryList() {
        Function<ListAuthenticationProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.authenticationProfileSummaryList() != null) {
                return response.authenticationProfileSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAuthenticationProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAuthenticationProfilesResponseFetcher
    implements AsyncPageFetcher<ListAuthenticationProfilesResponse> {
        private ListAuthenticationProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListAuthenticationProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAuthenticationProfilesResponse> nextPage(ListAuthenticationProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListAuthenticationProfilesPublisher.this.client.listAuthenticationProfiles(ListAuthenticationProfilesPublisher.this.firstRequest);
            }
            return ListAuthenticationProfilesPublisher.this.client.listAuthenticationProfiles((ListAuthenticationProfilesRequest)((Object)ListAuthenticationProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

