/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AllowedAccessControlTagsCopier;
import software.amazon.awssdk.services.connect.model.HierarchyRestrictedResourceListCopier;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.services.connect.model.TagRestrictedResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityProfile> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(SecurityProfile.getter(SecurityProfile::id)).setter(SecurityProfile.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ORGANIZATION_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationResourceId").getter(SecurityProfile.getter(SecurityProfile::organizationResourceId)).setter(SecurityProfile.setter(Builder::organizationResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationResourceId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(SecurityProfile.getter(SecurityProfile::arn)).setter(SecurityProfile.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityProfileName").getter(SecurityProfile.getter(SecurityProfile::securityProfileName)).setter(SecurityProfile.setter(Builder::securityProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfileName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SecurityProfile.getter(SecurityProfile::description)).setter(SecurityProfile.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(SecurityProfile.getter(SecurityProfile::tags)).setter(SecurityProfile.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ALLOWED_ACCESS_CONTROL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AllowedAccessControlTags").getter(SecurityProfile.getter(SecurityProfile::allowedAccessControlTags)).setter(SecurityProfile.setter(Builder::allowedAccessControlTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedAccessControlTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TAG_RESTRICTED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagRestrictedResources").getter(SecurityProfile.getter(SecurityProfile::tagRestrictedResources)).setter(SecurityProfile.setter(Builder::tagRestrictedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagRestrictedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(SecurityProfile.getter(SecurityProfile::lastModifiedTime)).setter(SecurityProfile.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(SecurityProfile.getter(SecurityProfile::lastModifiedRegion)).setter(SecurityProfile.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final SdkField<List<String>> HIERARCHY_RESTRICTED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HierarchyRestrictedResources").getter(SecurityProfile.getter(SecurityProfile::hierarchyRestrictedResources)).setter(SecurityProfile.setter(Builder::hierarchyRestrictedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyRestrictedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ALLOWED_ACCESS_CONTROL_HIERARCHY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowedAccessControlHierarchyGroupId").getter(SecurityProfile.getter(SecurityProfile::allowedAccessControlHierarchyGroupId)).setter(SecurityProfile.setter(Builder::allowedAccessControlHierarchyGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedAccessControlHierarchyGroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ORGANIZATION_RESOURCE_ID_FIELD, ARN_FIELD, SECURITY_PROFILE_NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, ALLOWED_ACCESS_CONTROL_TAGS_FIELD, TAG_RESTRICTED_RESOURCES_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD, HIERARCHY_RESTRICTED_RESOURCES_FIELD, ALLOWED_ACCESS_CONTROL_HIERARCHY_GROUP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("OrganizationResourceId", ORGANIZATION_RESOURCE_ID_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("SecurityProfileName", SECURITY_PROFILE_NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("AllowedAccessControlTags", ALLOWED_ACCESS_CONTROL_TAGS_FIELD);
            this.put("TagRestrictedResources", TAG_RESTRICTED_RESOURCES_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
            this.put("HierarchyRestrictedResources", HIERARCHY_RESTRICTED_RESOURCES_FIELD);
            this.put("AllowedAccessControlHierarchyGroupId", ALLOWED_ACCESS_CONTROL_HIERARCHY_GROUP_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String organizationResourceId;
    private final String arn;
    private final String securityProfileName;
    private final String description;
    private final Map<String, String> tags;
    private final Map<String, String> allowedAccessControlTags;
    private final List<String> tagRestrictedResources;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;
    private final List<String> hierarchyRestrictedResources;
    private final String allowedAccessControlHierarchyGroupId;

    private SecurityProfile(BuilderImpl builder) {
        this.id = builder.id;
        this.organizationResourceId = builder.organizationResourceId;
        this.arn = builder.arn;
        this.securityProfileName = builder.securityProfileName;
        this.description = builder.description;
        this.tags = builder.tags;
        this.allowedAccessControlTags = builder.allowedAccessControlTags;
        this.tagRestrictedResources = builder.tagRestrictedResources;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
        this.hierarchyRestrictedResources = builder.hierarchyRestrictedResources;
        this.allowedAccessControlHierarchyGroupId = builder.allowedAccessControlHierarchyGroupId;
    }

    public final String id() {
        return this.id;
    }

    public final String organizationResourceId() {
        return this.organizationResourceId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String securityProfileName() {
        return this.securityProfileName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasAllowedAccessControlTags() {
        return this.allowedAccessControlTags != null && !(this.allowedAccessControlTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> allowedAccessControlTags() {
        return this.allowedAccessControlTags;
    }

    public final boolean hasTagRestrictedResources() {
        return this.tagRestrictedResources != null && !(this.tagRestrictedResources instanceof SdkAutoConstructList);
    }

    public final List<String> tagRestrictedResources() {
        return this.tagRestrictedResources;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public final boolean hasHierarchyRestrictedResources() {
        return this.hierarchyRestrictedResources != null && !(this.hierarchyRestrictedResources instanceof SdkAutoConstructList);
    }

    public final List<String> hierarchyRestrictedResources() {
        return this.hierarchyRestrictedResources;
    }

    public final String allowedAccessControlHierarchyGroupId() {
        return this.allowedAccessControlHierarchyGroupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedAccessControlTags() ? this.allowedAccessControlTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagRestrictedResources() ? this.tagRestrictedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHierarchyRestrictedResources() ? this.hierarchyRestrictedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedAccessControlHierarchyGroupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityProfile)) {
            return false;
        }
        SecurityProfile other = (SecurityProfile)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.organizationResourceId(), other.organizationResourceId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasAllowedAccessControlTags() == other.hasAllowedAccessControlTags() && Objects.equals(this.allowedAccessControlTags(), other.allowedAccessControlTags()) && this.hasTagRestrictedResources() == other.hasTagRestrictedResources() && Objects.equals(this.tagRestrictedResources(), other.tagRestrictedResources()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion()) && this.hasHierarchyRestrictedResources() == other.hasHierarchyRestrictedResources() && Objects.equals(this.hierarchyRestrictedResources(), other.hierarchyRestrictedResources()) && Objects.equals(this.allowedAccessControlHierarchyGroupId(), other.allowedAccessControlHierarchyGroupId());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityProfile").add("Id", (Object)this.id()).add("OrganizationResourceId", (Object)this.organizationResourceId()).add("Arn", (Object)this.arn()).add("SecurityProfileName", (Object)this.securityProfileName()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("AllowedAccessControlTags", this.hasAllowedAccessControlTags() ? this.allowedAccessControlTags() : null).add("TagRestrictedResources", this.hasTagRestrictedResources() ? this.tagRestrictedResources() : null).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).add("HierarchyRestrictedResources", this.hasHierarchyRestrictedResources() ? this.hierarchyRestrictedResources() : null).add("AllowedAccessControlHierarchyGroupId", (Object)this.allowedAccessControlHierarchyGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "OrganizationResourceId": {
                return Optional.ofNullable(clazz.cast(this.organizationResourceId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "SecurityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AllowedAccessControlTags": {
                return Optional.ofNullable(clazz.cast(this.allowedAccessControlTags()));
            }
            case "TagRestrictedResources": {
                return Optional.ofNullable(clazz.cast(this.tagRestrictedResources()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
            case "HierarchyRestrictedResources": {
                return Optional.ofNullable(clazz.cast(this.hierarchyRestrictedResources()));
            }
            case "AllowedAccessControlHierarchyGroupId": {
                return Optional.ofNullable(clazz.cast(this.allowedAccessControlHierarchyGroupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SecurityProfile, T> g) {
        return obj -> g.apply((SecurityProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String organizationResourceId;
        private String arn;
        private String securityProfileName;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> allowedAccessControlTags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> tagRestrictedResources = DefaultSdkAutoConstructList.getInstance();
        private Instant lastModifiedTime;
        private String lastModifiedRegion;
        private List<String> hierarchyRestrictedResources = DefaultSdkAutoConstructList.getInstance();
        private String allowedAccessControlHierarchyGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityProfile model) {
            this.id(model.id);
            this.organizationResourceId(model.organizationResourceId);
            this.arn(model.arn);
            this.securityProfileName(model.securityProfileName);
            this.description(model.description);
            this.tags(model.tags);
            this.allowedAccessControlTags(model.allowedAccessControlTags);
            this.tagRestrictedResources(model.tagRestrictedResources);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
            this.hierarchyRestrictedResources(model.hierarchyRestrictedResources);
            this.allowedAccessControlHierarchyGroupId(model.allowedAccessControlHierarchyGroupId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOrganizationResourceId() {
            return this.organizationResourceId;
        }

        public final void setOrganizationResourceId(String organizationResourceId) {
            this.organizationResourceId = organizationResourceId;
        }

        @Override
        public final Builder organizationResourceId(String organizationResourceId) {
            this.organizationResourceId = organizationResourceId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Map<String, String> getAllowedAccessControlTags() {
            if (this.allowedAccessControlTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.allowedAccessControlTags;
        }

        public final void setAllowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
            this.allowedAccessControlTags = AllowedAccessControlTagsCopier.copy(allowedAccessControlTags);
        }

        @Override
        public final Builder allowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
            this.allowedAccessControlTags = AllowedAccessControlTagsCopier.copy(allowedAccessControlTags);
            return this;
        }

        public final Collection<String> getTagRestrictedResources() {
            if (this.tagRestrictedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagRestrictedResources;
        }

        public final void setTagRestrictedResources(Collection<String> tagRestrictedResources) {
            this.tagRestrictedResources = TagRestrictedResourceListCopier.copy(tagRestrictedResources);
        }

        @Override
        public final Builder tagRestrictedResources(Collection<String> tagRestrictedResources) {
            this.tagRestrictedResources = TagRestrictedResourceListCopier.copy(tagRestrictedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagRestrictedResources(String ... tagRestrictedResources) {
            this.tagRestrictedResources(Arrays.asList(tagRestrictedResources));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public final Collection<String> getHierarchyRestrictedResources() {
            if (this.hierarchyRestrictedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hierarchyRestrictedResources;
        }

        public final void setHierarchyRestrictedResources(Collection<String> hierarchyRestrictedResources) {
            this.hierarchyRestrictedResources = HierarchyRestrictedResourceListCopier.copy(hierarchyRestrictedResources);
        }

        @Override
        public final Builder hierarchyRestrictedResources(Collection<String> hierarchyRestrictedResources) {
            this.hierarchyRestrictedResources = HierarchyRestrictedResourceListCopier.copy(hierarchyRestrictedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchyRestrictedResources(String ... hierarchyRestrictedResources) {
            this.hierarchyRestrictedResources(Arrays.asList(hierarchyRestrictedResources));
            return this;
        }

        public final String getAllowedAccessControlHierarchyGroupId() {
            return this.allowedAccessControlHierarchyGroupId;
        }

        public final void setAllowedAccessControlHierarchyGroupId(String allowedAccessControlHierarchyGroupId) {
            this.allowedAccessControlHierarchyGroupId = allowedAccessControlHierarchyGroupId;
        }

        @Override
        public final Builder allowedAccessControlHierarchyGroupId(String allowedAccessControlHierarchyGroupId) {
            this.allowedAccessControlHierarchyGroupId = allowedAccessControlHierarchyGroupId;
            return this;
        }

        public SecurityProfile build() {
            return new SecurityProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityProfile> {
        public Builder id(String var1);

        public Builder organizationResourceId(String var1);

        public Builder arn(String var1);

        public Builder securityProfileName(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder allowedAccessControlTags(Map<String, String> var1);

        public Builder tagRestrictedResources(Collection<String> var1);

        public Builder tagRestrictedResources(String ... var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);

        public Builder hierarchyRestrictedResources(Collection<String> var1);

        public Builder hierarchyRestrictedResources(String ... var1);

        public Builder allowedAccessControlHierarchyGroupId(String var1);
    }
}

