/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.HoursOfOperation;
import software.amazon.awssdk.services.connect.model.HoursOfOperationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchHoursOfOperationsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchHoursOfOperationsResponse> {
    private static final SdkField<List<HoursOfOperation>> HOURS_OF_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HoursOfOperations").getter(SearchHoursOfOperationsResponse.getter(SearchHoursOfOperationsResponse::hoursOfOperations)).setter(SearchHoursOfOperationsResponse.setter(Builder::hoursOfOperations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HoursOfOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchHoursOfOperationsResponse.getter(SearchHoursOfOperationsResponse::nextToken)).setter(SearchHoursOfOperationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(SearchHoursOfOperationsResponse.getter(SearchHoursOfOperationsResponse::approximateTotalCount)).setter(SearchHoursOfOperationsResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOURS_OF_OPERATIONS_FIELD, NEXT_TOKEN_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("HoursOfOperations", HOURS_OF_OPERATIONS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        }
    });
    private final List<HoursOfOperation> hoursOfOperations;
    private final String nextToken;
    private final Long approximateTotalCount;

    private SearchHoursOfOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.hoursOfOperations = builder.hoursOfOperations;
        this.nextToken = builder.nextToken;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final boolean hasHoursOfOperations() {
        return this.hoursOfOperations != null && !(this.hoursOfOperations instanceof SdkAutoConstructList);
    }

    public final List<HoursOfOperation> hoursOfOperations() {
        return this.hoursOfOperations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHoursOfOperations() ? this.hoursOfOperations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchHoursOfOperationsResponse)) {
            return false;
        }
        SearchHoursOfOperationsResponse other = (SearchHoursOfOperationsResponse)((Object)obj);
        return this.hasHoursOfOperations() == other.hasHoursOfOperations() && Objects.equals(this.hoursOfOperations(), other.hoursOfOperations()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchHoursOfOperationsResponse").add("HoursOfOperations", this.hasHoursOfOperations() ? this.hoursOfOperations() : null).add("NextToken", (Object)this.nextToken()).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HoursOfOperations": {
                return Optional.ofNullable(clazz.cast(this.hoursOfOperations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchHoursOfOperationsResponse, T> g) {
        return obj -> g.apply((SearchHoursOfOperationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<HoursOfOperation> hoursOfOperations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchHoursOfOperationsResponse model) {
            super(model);
            this.hoursOfOperations(model.hoursOfOperations);
            this.nextToken(model.nextToken);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final List<HoursOfOperation.Builder> getHoursOfOperations() {
            List<HoursOfOperation.Builder> result = HoursOfOperationListCopier.copyToBuilder(this.hoursOfOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHoursOfOperations(Collection<HoursOfOperation.BuilderImpl> hoursOfOperations) {
            this.hoursOfOperations = HoursOfOperationListCopier.copyFromBuilder(hoursOfOperations);
        }

        @Override
        public final Builder hoursOfOperations(Collection<HoursOfOperation> hoursOfOperations) {
            this.hoursOfOperations = HoursOfOperationListCopier.copy(hoursOfOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hoursOfOperations(HoursOfOperation ... hoursOfOperations) {
            this.hoursOfOperations(Arrays.asList(hoursOfOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hoursOfOperations(Consumer<HoursOfOperation.Builder> ... hoursOfOperations) {
            this.hoursOfOperations(Stream.of(hoursOfOperations).map(c -> (HoursOfOperation)((HoursOfOperation.Builder)HoursOfOperation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchHoursOfOperationsResponse build() {
            return new SearchHoursOfOperationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchHoursOfOperationsResponse> {
        public Builder hoursOfOperations(Collection<HoursOfOperation> var1);

        public Builder hoursOfOperations(HoursOfOperation ... var1);

        public Builder hoursOfOperations(Consumer<HoursOfOperation.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder approximateTotalCount(Long var1);
    }
}

