/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.QuickConnectsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateQueueQuickConnectsRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, AssociateQueueQuickConnectsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(AssociateQueueQuickConnectsRequest.getter(AssociateQueueQuickConnectsRequest::instanceId)).setter(AssociateQueueQuickConnectsRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueId").getter(AssociateQueueQuickConnectsRequest.getter(AssociateQueueQuickConnectsRequest::queueId)).setter(AssociateQueueQuickConnectsRequest.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("QueueId").build()}).build();
    private static final SdkField<List<String>> QUICK_CONNECT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QuickConnectIds").getter(AssociateQueueQuickConnectsRequest.getter(AssociateQueueQuickConnectsRequest::quickConnectIds)).setter(AssociateQueueQuickConnectsRequest.setter(Builder::quickConnectIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, QUEUE_ID_FIELD, QUICK_CONNECT_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("QueueId", QUEUE_ID_FIELD);
            this.put("QuickConnectIds", QUICK_CONNECT_IDS_FIELD);
        }
    });
    private final String instanceId;
    private final String queueId;
    private final List<String> quickConnectIds;

    private AssociateQueueQuickConnectsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.queueId = builder.queueId;
        this.quickConnectIds = builder.quickConnectIds;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final boolean hasQuickConnectIds() {
        return this.quickConnectIds != null && !(this.quickConnectIds instanceof SdkAutoConstructList);
    }

    public final List<String> quickConnectIds() {
        return this.quickConnectIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuickConnectIds() ? this.quickConnectIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateQueueQuickConnectsRequest)) {
            return false;
        }
        AssociateQueueQuickConnectsRequest other = (AssociateQueueQuickConnectsRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.queueId(), other.queueId()) && this.hasQuickConnectIds() == other.hasQuickConnectIds() && Objects.equals(this.quickConnectIds(), other.quickConnectIds());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateQueueQuickConnectsRequest").add("InstanceId", (Object)this.instanceId()).add("QueueId", (Object)this.queueId()).add("QuickConnectIds", this.hasQuickConnectIds() ? this.quickConnectIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "QueueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "QuickConnectIds": {
                return Optional.ofNullable(clazz.cast(this.quickConnectIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociateQueueQuickConnectsRequest, T> g) {
        return obj -> g.apply((AssociateQueueQuickConnectsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String queueId;
        private List<String> quickConnectIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateQueueQuickConnectsRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.queueId(model.queueId);
            this.quickConnectIds(model.quickConnectIds);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final Collection<String> getQuickConnectIds() {
            if (this.quickConnectIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.quickConnectIds;
        }

        public final void setQuickConnectIds(Collection<String> quickConnectIds) {
            this.quickConnectIds = QuickConnectsListCopier.copy(quickConnectIds);
        }

        @Override
        public final Builder quickConnectIds(Collection<String> quickConnectIds) {
            this.quickConnectIds = QuickConnectsListCopier.copy(quickConnectIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickConnectIds(String ... quickConnectIds) {
            this.quickConnectIds(Arrays.asList(quickConnectIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateQueueQuickConnectsRequest build() {
            return new AssociateQueueQuickConnectsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateQueueQuickConnectsRequest> {
        public Builder instanceId(String var1);

        public Builder queueId(String var1);

        public Builder quickConnectIds(Collection<String> var1);

        public Builder quickConnectIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

